/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.news.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.news.model.AddPostData;
import de.justsoftware.mobile.gateway.news.model.Channel;
import de.justsoftware.mobile.gateway.news.model.Comment;
import de.justsoftware.mobile.gateway.news.model.CommentContent;
import de.justsoftware.mobile.gateway.news.model.Poll;
import de.justsoftware.mobile.gateway.news.model.PollVotes;
import de.justsoftware.mobile.gateway.news.model.Post;
import de.justsoftware.mobile.gateway.news.model.UpdatePostData;
import de.justsoftware.mobile.gateway.news.service.NewsService;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/news"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0017J$\u0010\r\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u000e\u001a\u00020\bH\u0017J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0014\u001a\u00020\u00132\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u0015\u001a\u00020\u00132\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J>\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0017J6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00172\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001f\u001a\u00020\bH\u0017J\u0012\u0010 \u001a\u00020\u00192\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0017J4\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\b\b\u0001\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u001a\u001a\u00020\u00192\b\b\u0001\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010#\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J$\u0010$\u001a\u00020%2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u0010&\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u0010(\u001a\u00020\u00112\b\b\u0001\u0010\u000e\u001a\u00020\bH\u0017J8\u0010)\u001a\u00020%2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010*\u001a\u00020\b2\b\b\u0001\u0010+\u001a\u00020\b2\b\b\u0001\u0010,\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\fH\u0017J$\u0010.\u001a\u00020%2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010,\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u0010/\u001a\u00020\u00132\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J$\u00100\u001a\u00020%2\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001a\u00101\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0012\u00102\u001a\u00020\u00132\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J&\u00103\u001a\u0004\u0018\u00010%2\b\b\u0001\u0010\u000f\u001a\u00020\b2\b\b\u0001\u00104\u001a\u00020-2\u0006\u0010\u000b\u001a\u00020\fH\u0017J$\u00105\u001a\u00020\u00062\b\b\u0001\u0010\u000e\u001a\u00020\b2\b\b\u0001\u00106\u001a\u0002072\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u001c\u00108\u001a\u0002092\b\b\u0001\u0010:\u001a\u00020\b2\b\b\u0001\u0010;\u001a\u00020<H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lde/justsoftware/mobile/gateway/news/controller/NewsController;", "", "newsService", "Lde/justsoftware/mobile/gateway/news/service/NewsService;", "(Lde/justsoftware/mobile/gateway/news/service/NewsService;)V", "addPost", "Lde/justsoftware/mobile/gateway/news/model/Post;", "channelId", "", "addPostData", "Lde/justsoftware/mobile/gateway/news/model/AddPostData;", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "deleteComment", "postId", "commentId", "deletePost", "", "disableNotifications", "Lde/justsoftware/mobile/gateway/news/model/Channel;", "enableNotifications", "getChannel", "getChannelPosts", "", "offset", "", "limit", "pinned", "", "getChannelSubscribers", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "getChannelSubscribersCount", "getChannels", "getFeed", "getPost", "likeComment", "Lde/justsoftware/mobile/gateway/news/model/Comment;", "likePost", "markFeedAsRead", "markPostAsRead", "respondToComment", "parentId", "referenceId", "response", "Lde/justsoftware/mobile/gateway/news/model/CommentContent;", "respondToPost", "subscribe", "unlikeComment", "unlikePost", "unsubscribe", "updateComment", "updatedContent", "updatePost", "updatePostData", "Lde/justsoftware/mobile/gateway/news/model/UpdatePostData;", "voteForPoll", "Lde/justsoftware/mobile/gateway/news/model/Poll;", "pollId", "votes", "Lde/justsoftware/mobile/gateway/news/model/PollVotes;", "mobile-gateway"})
public class NewsController {
    @NotNull
    private final NewsService newsService;

    public NewsController(@NotNull NewsService newsService) {
        Intrinsics.checkNotNullParameter((Object)newsService, (String)"newsService");
        this.newsService = newsService;
    }

    @GetMapping(value={"/feed"})
    @NotNull
    public List<Post> getFeed(@RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(name="pinned", defaultValue="false") boolean pinned, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getFeed(offset, limit, pinned, authContext.getProfileId());
    }

    @PostMapping(value={"/feed/read"})
    public void markFeedAsRead(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.newsService.markFeedAsRead();
    }

    @GetMapping(value={"/channels"})
    @NotNull
    public List<Channel> getChannels() {
        return this.newsService.getChannels();
    }

    @PostMapping(value={"/channels/{id}/subscribe"})
    @NotNull
    public Channel subscribe(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return NewsService.subscribe$default((NewsService)this.newsService, (String)channelId, (boolean)false, (int)2, null);
    }

    @PostMapping(value={"/channels/{id}/unsubscribe"})
    @NotNull
    public Channel unsubscribe(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.unsubscribe(channelId);
    }

    @PostMapping(value={"/channels/{id}/enableNotifications"})
    @NotNull
    public Channel enableNotifications(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, true);
    }

    @PostMapping(value={"/channels/{id}/disableNotifications"})
    @NotNull
    public Channel disableNotifications(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.subscribe(channelId, false);
    }

    @GetMapping(value={"/channels/{id}"})
    @NotNull
    public Channel getChannel(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.getChannel(channelId);
    }

    @GetMapping(value={"/channels/{id}/posts"})
    @NotNull
    public List<Post> getChannelPosts(@PathVariable(value="id") @NotNull String channelId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="10") int limit, @RequestParam(name="pinned", defaultValue="false") boolean pinned, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getChannelPosts(channelId, offset, limit, false, pinned, authContext.getProfileId());
    }

    @GetMapping(value={"/channels/{id}/subscribers"})
    @NotNull
    public List<Profile> getChannelSubscribers(@PathVariable(value="id") @NotNull String channelId, @RequestParam(name="offset", defaultValue="0") int offset, @RequestParam(name="limit", defaultValue="100") int limit, @RequestParam(name="query", defaultValue="") @NotNull String query) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return this.newsService.getChannelSubscribers(channelId, offset, limit, query);
    }

    @GetMapping(value={"/channels/{id}/subscribersCount"})
    public int getChannelSubscribersCount(@PathVariable(value="id") @NotNull String channelId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        return this.newsService.getChannelSubscribersCount(channelId);
    }

    @PostMapping(value={"/channels/{id}/posts"})
    @NotNull
    public Post addPost(@PathVariable(value="id") @NotNull String channelId, @RequestBody @NotNull AddPostData addPostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        Intrinsics.checkNotNullParameter((Object)addPostData, (String)"addPostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.addPost(channelId, addPostData, authContext.getProfileId());
    }

    @GetMapping(value={"/posts/{id}"})
    @NotNull
    public Post getPost(@PathVariable(value="id") @NotNull String postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.getPost(postId, authContext.getProfileId());
    }

    @PutMapping(value={"/posts/{id}"})
    @NotNull
    public Post updatePost(@PathVariable(value="id") @NotNull String postId, @RequestBody @NotNull UpdatePostData updatePostData, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)updatePostData, (String)"updatePostData");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.updatePost(postId, updatePostData, authContext.getProfileId());
    }

    @DeleteMapping(value={"/posts/{id}"})
    public void deletePost(@PathVariable(value="id") @NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.newsService.deletePost(postId);
    }

    @PostMapping(value={"/posts/{id}/like"})
    @NotNull
    public Post likePost(@PathVariable(value="id") @NotNull String postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.likePost(postId, authContext.getProfileId());
    }

    @PostMapping(value={"/posts/{id}/unlike"})
    @NotNull
    public Post unlikePost(@PathVariable(value="id") @NotNull String postId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.unlikePost(postId, authContext.getProfileId());
    }

    @PostMapping(value={"/posts/{postId}/comments"})
    @NotNull
    public Comment respondToPost(@PathVariable(value="postId") @NotNull String postId, @RequestBody @NotNull CommentContent response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return NewsService.addComment$default((NewsService)this.newsService, (String)postId, null, null, (CommentContent)response, (String)authContext.getProfileId(), (int)6, null);
    }

    @PostMapping(value={"/posts/{postId}/comments/{commentId}/like"})
    @NotNull
    public Comment likeComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.likeComment(postId, commentId, authContext.getProfileId());
    }

    @PostMapping(value={"/posts/{postId}/comments/{commentId}/unlike"})
    @NotNull
    public Comment unlikeComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.unlikeComment(postId, commentId, authContext.getProfileId());
    }

    @PostMapping(value={"/posts/{postId}/comments/{parentId}/{referenceId}"})
    @NotNull
    public Comment respondToComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="parentId") @NotNull String parentId, @PathVariable(value="referenceId") @NotNull String referenceId, @RequestBody @NotNull CommentContent response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)referenceId, (String)"referenceId");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.addComment(postId, parentId, referenceId, response, authContext.getProfileId());
    }

    @PutMapping(value={"/posts/{postId}/comments/{commentId}"})
    @Nullable
    public Comment updateComment(@PathVariable(value="commentId") @NotNull String commentId, @RequestBody @NotNull CommentContent updatedContent, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)updatedContent, (String)"updatedContent");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.updateComment(commentId, updatedContent, authContext.getProfileId());
    }

    @DeleteMapping(value={"/posts/{postId}/comments/{commentId}"})
    @NotNull
    public Post deleteComment(@PathVariable(value="postId") @NotNull String postId, @PathVariable(value="commentId") @NotNull String commentId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.newsService.deleteComment(postId, commentId, authContext.getProfileId());
    }

    @PostMapping(value={"/posts/{postId}/read"})
    public void markPostAsRead(@PathVariable(value="postId") @NotNull String postId) {
        Intrinsics.checkNotNullParameter((Object)postId, (String)"postId");
        this.newsService.markPostAsRead(postId);
    }

    @PutMapping(value={"/polls/{id}/vote"})
    @NotNull
    public Poll voteForPoll(@PathVariable(value="id") @NotNull String pollId, @RequestBody @NotNull PollVotes votes) {
        Intrinsics.checkNotNullParameter((Object)pollId, (String)"pollId");
        Intrinsics.checkNotNullParameter((Object)votes, (String)"votes");
        return this.newsService.voteForPoll(pollId, votes.getAnswerIds());
    }
}

