--liquibase formatted sql

--changeset bjrke:add_timestamps dbms:postgresql runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION update_mtime()
RETURNS TRIGGER AS $$
BEGIN
   NEW.mtime = clock_timestamp();
   RETURN NEW;
END;
$$ language 'plpgsql';

CREATE OR REPLACE FUNCTION ctime_mtime_columns(tname TEXT)
RETURNS VOID AS $$
BEGIN
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN ctime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'ALTER TABLE ' || tname || ' ADD COLUMN mtime TIMESTAMP WITHOUT TIME ZONE NOT NULL DEFAULT clock_timestamp();';
    EXECUTE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW EXECUTE PROCEDURE update_mtime();';
END;
$$ language 'plpgsql';

--changeset bjrke:add_now_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION now
    RETURN DATE
AS
BEGIN
    RETURN SYSDATE;
END now;

--changeset bjrke:add_clock_timestamp_function dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE FUNCTION clock_timestamp
    RETURN TIMESTAMP WITH TIME ZONE
AS
BEGIN
    RETURN SYSTIMESTAMP;
END clock_timestamp;

--changeset bjrke:add_timestamps dbms:oracle runAlways:true splitStatements:false
CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_mtrg BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;


--changeset mdoelle:create_external_id_mapping_table
CREATE TABLE external_id_mapping (
    tenant_id ${uuid} NOT NULL,
    external_system ${varchar255} NOT NULL,
    internal_id ${varchar255} NOT NULL,
    external_id ${varchar255} NOT NULL
);
${execute} ctime_mtime_columns('external_id_mapping');

--changeset mdoelle:add_constraints_for_external_id_mapping
ALTER TABLE external_id_mapping ADD CONSTRAINT ex_id_m_internal_uq UNIQUE (tenant_id, external_system, internal_id);
ALTER TABLE external_id_mapping ADD CONSTRAINT ex_id_m_external_uq UNIQUE (tenant_id, external_system, external_id);

