/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.usergroup.ldap;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.justimport.domain.JustLdapUtils;
import de.justsoftware.justimport.domain.impl.usergroup.ldap.MembersLookupResult;
import de.justsoftware.justimport.domain.usergroup.ldap.LdapUserGroupCustomRepository;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class LdapUserGroupRepositoryImpl
implements LdapUserGroupCustomRepository {
    private static final Logger LOG = LoggerFactory.getLogger(LdapUserGroupRepositoryImpl.class);
    private final LdapTemplate _ldapTemplate;
    private final LdapName _ldapBase;
    private final ContextMapper<MembersLookupResult> _contextMapper;
    private final String _membershipAttribute;

    @Autowired
    public LdapUserGroupRepositoryImpl(LdapTemplate ldapTemplate, @Value(value="${just.import.usergroup.ldap.membershipAttribute:memberOf}") String membershipAttribute) {
        this._ldapTemplate = ldapTemplate;
        this._ldapBase = JustLdapUtils.determineLdapBase((LdapTemplate)this._ldapTemplate);
        this._contextMapper = ctx -> {
            DirContextAdapter context = (DirContextAdapter)ctx;
            return new MembersLookupResult(JustLdapUtils.normalizeDn((Name)context.getDn(), (Name)this._ldapBase), context.getStringAttributes("member"));
        };
        this._membershipAttribute = membershipAttribute;
    }

    public Set<Name> getAllMembers(Name groupDN) throws InvalidNameException {
        Name normalizedDn = JustLdapUtils.normalizeDn((Name)groupDN, (Name)this._ldapBase);
        return this.getAllMembersWithSubgroups(normalizedDn);
    }

    @Nonnull
    private Set<MembersLookupResult> lookupMembers(Name groupDN) {
        EqualsFilter memberOfFilter = new EqualsFilter(this._membershipAttribute, groupDN.toString());
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"dn", "member"});
        searchControls.setSearchScope(2);
        List search = this._ldapTemplate.search("", memberOfFilter.encode(), searchControls, this._contextMapper);
        return (Set)search.stream().collect(ImmutableSet.toImmutableSet());
    }

    @Nonnull
    private Set<Name> getAllMembersWithSubgroups(Name topLevelName) {
        HashSet<Name> personsFound = new HashSet<Name>();
        HashSet<Name> groupsToVisit = new HashSet<Name>(Set.of(topLevelName));
        HashSet<Name> visitedGroups = new HashSet<Name>();
        while (!groupsToVisit.isEmpty()) {
            Name node = (Name)groupsToVisit.stream().findFirst().get();
            if (visitedGroups.contains(node)) {
                groupsToVisit.remove(node);
                continue;
            }
            Set subNodes = this.lookupMembers(node);
            personsFound.addAll(this.getPersons(subNodes));
            groupsToVisit.addAll(this.getGroups(subNodes));
            groupsToVisit.remove(node);
            visitedGroups.add(node);
        }
        LOG.info("Made {} ldap queries to resolve group {}", (Object)visitedGroups.size(), (Object)topLevelName);
        return personsFound;
    }

    @Nonnull
    private Set<Name> getPersons(Set<MembersLookupResult> members) {
        return members.stream().filter(MembersLookupResult::isPerson).map(MembersLookupResult::getDn).collect(Collectors.toSet());
    }

    @Nonnull
    private Set<Name> getGroups(Set<MembersLookupResult> members) {
        return members.stream().filter(MembersLookupResult::isGroup).map(MembersLookupResult::getDn).collect(Collectors.toSet());
    }
}

