/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl.externalid;

import de.justsoftware.justimport.domain.model.common.TenantId;
import de.justsoftware.justimport.domain.model.externalid.ExternalId;
import de.justsoftware.justimport.domain.model.externalid.ExternalIdMapping;
import de.justsoftware.justimport.domain.model.externalid.ExternalSystemId;
import de.justsoftware.justimport.domain.model.externalid.InternalId;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@Mapper
@ParametersAreNonnullByDefault
public interface ExternalIdMappingMapper {
    @Insert(value={"<script>", "INSERT INTO external_id_mapping (tenant_id, external_system, internal_id, external_id)", "   SELECT #{mapping.tenantId}, #{mapping.systemId}, #{mapping.internalId}, #{mapping.externalId} ", "   <if test=\"_databaseId == 'ORACLE'\">FROM dual</if>", "   WHERE NOT EXISTS (SELECT 1 FROM external_id_mapping ", "                     WHERE tenant_id = #{mapping.tenantId} and external_system = #{mapping.systemId} ", "                     and (internal_id = #{mapping.internalId} or external_id = #{mapping.externalId}) )", "</script>"})
    public void insert(@Param(value="mapping") ExternalIdMapping var1);

    @Update(value={"UPDATE external_id_mapping", "SET external_id = #{mapping.externalId}, internal_id = #{mapping.internalId} ", "WHERE tenant_id = #{mapping.tenantId} and external_system = #{mapping.systemId} ", "and (internal_id = #{mapping.internalId} or external_id = #{mapping.externalId})"})
    public void update(@Param(value="mapping") ExternalIdMapping var1);

    @Delete(value={"<script>", "DELETE FROM external_id_mapping", "WHERE external_system = #{systemId} AND tenant_id = #{tenantId} AND internal_id IN", "(<foreach collection='internalIds' item='internalId' separator=','>#{internalId}</foreach>)", "</script>"})
    public void delete(@Param(value="tenantId") TenantId var1, @Param(value="systemId") ExternalSystemId var2, @Param(value="internalIds") Set<? extends InternalId> var3);

    @Delete(value={"<script>", "DELETE FROM external_id_mapping", "WHERE internal_id IN", "(<foreach collection='internalIds' item='internalId' separator=','>#{internalId}</foreach>)", "</script>"})
    public void deleteAllForInternalIds(@Param(value="internalIds") Set<? extends InternalId> var1);

    @ResultType(value=ExternalIdMapping.class)
    @ConstructorArgs(value={@Arg(javaType=TenantId.class, column="tenant_id"), @Arg(javaType=ExternalSystemId.class, column="external_system"), @Arg(javaType=InternalId.class, column="internal_id"), @Arg(javaType=ExternalId.class, column="external_id")})
    @Select(value={"<script>", "SELECT tenant_id, external_system, internal_id, external_id ", "FROM external_id_mapping", "WHERE external_id IN ", "(<foreach collection='externalIds' item='externalId' separator=','>#{externalId}</foreach>)", "AND external_system = #{systemId} AND tenant_id = #{tenantId}", "</script>"})
    public void getByExternalId(ResultHandler<ExternalIdMapping> var1, @Param(value="tenantId") TenantId var2, @Param(value="systemId") ExternalSystemId var3, @Param(value="externalIds") List<ExternalId> var4);
}

