/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.domain.impl;

import de.justsoftware.justimport.domain.impl.JdbcConnectionConfiguration;
import de.justsoftware.justimport.domain.impl.JdbcConnectionConfigurationImpl;
import de.justsoftware.justimport.domain.impl.JustImportPersistenceScanMarker;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import de.justsoftware.toolbox.mybatis.SupportedJdbcDriver;
import de.justsoftware.toolbox.mybatis.result.DAOSupportImpl;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(basePackageClasses={JustImportPersistenceScanMarker.class}, basePackages={"de.justsoftware.justimport.transaction.impl"}, sqlSessionFactoryRef="sqlSessionFactory")
@ParametersAreNonnullByDefault
public class JustImportPersistenceConfiguration {
    @Bean
    @Nonnull
    public JdbcConnectionConfiguration jdbcConnectionConfiguration(@Value(value="${spring.datasource.url}") String jdbcUrl, @Value(value="${spring.datasource.username}") String jdbcUser, @Value(value="${spring.datasource.password}") String jdbcPassword) {
        return new JdbcConnectionConfigurationImpl(jdbcUrl, jdbcUser, jdbcPassword);
    }

    @Bean
    @Nonnull
    public DAOSupport daoSupport(JdbcConnectionConfiguration jdbcConnectionConfiguration) {
        SupportedJdbcDriver driver = jdbcConnectionConfiguration.driver();
        return new DAOSupportImpl(() -> driver);
    }
}

