/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.security.oauth2;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.gateway.security.oauth2.ClientTarget;
import de.justsoftware.gateway.security.oauth2.JustLoginHelper;
import de.justsoftware.gateway.security.oauth2.JustOauthLoginAuthenticationEntryPoint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesRegistrationAdapter;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoder;
import org.springframework.security.oauth2.jwt.ReactiveJwtDecoders;
import org.springframework.security.oauth2.server.resource.authentication.JwtReactiveAuthenticationManager;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Mono;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@ParametersAreNonnullByDefault
public class JustInMemoryClientRegistrationRepository
implements ReactiveClientRegistrationRepository,
Iterable<ClientRegistration> {
    private static final Logger LOG = LoggerFactory.getLogger(JustInMemoryClientRegistrationRepository.class);
    private static final Comparator<ClientRegistration> DEFAULT_IDP_COMPARATOR = (r1, r2) -> Boolean.compare(JustInMemoryClientRegistrationRepository.isDefault((ClientRegistration)r1), JustInMemoryClientRegistrationRepository.isDefault((ClientRegistration)r2));
    private final Map<String, ReactiveAuthenticationManager> _authenticationManagers = new HashMap();
    private final JustOauthLoginAuthenticationEntryPoint _justOauthLoginAuthenticationEntryPoint;
    private ImmutableMap<String, ClientRegistration> _registrations;
    private boolean _externalIdpConfigured = false;

    public JustInMemoryClientRegistrationRepository(OAuth2ClientProperties properties, JustOauthLoginAuthenticationEntryPoint justOauthLoginAuthenticationEntryPoint) {
        this._justOauthLoginAuthenticationEntryPoint = justOauthLoginAuthenticationEntryPoint;
        this._registrations = JustInMemoryClientRegistrationRepository.initializeRegistrations((OAuth2ClientProperties)properties);
        this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(this.getDefaultDesktopClient());
    }

    @Nonnull
    private static Predicate<ClientRegistration> clientsForTarget(ClientTarget target) {
        return r -> {
            Object targetsObject = r.getProviderDetails().getConfigurationMetadata().get("targets");
            if (targetsObject instanceof Set) {
                return ((Set)targetsObject).contains(target);
            }
            return false;
        };
    }

    private static boolean isDefault(ClientRegistration r) {
        return ((Object)r.getProviderDetails().getConfigurationMetadata().getOrDefault("defaultProvider", false)).equals(Boolean.TRUE);
    }

    @Nonnull
    private static ImmutableMap<String, ClientRegistration> initializeRegistrations(OAuth2ClientProperties properties) {
        return (ImmutableMap)OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)properties).values().stream().map(c -> {
            if (c.getRegistrationId().equals("just_mobile")) {
                return ClientRegistration.withClientRegistration((ClientRegistration)c).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.MOBILE_SOCIAL, ClientTarget.MOBILE_CONNECT))).build();
            }
            if (c.getRegistrationId().equals("just")) {
                return ClientRegistration.withClientRegistration((ClientRegistration)c).providerConfigurationMetadata(Map.of("targets", Set.of(ClientTarget.DESKTOP))).build();
            }
            return c;
        }).collect(ImmutableMap.toImmutableMap(ClientRegistration::getRegistrationId, Function.identity()));
    }

    @Override
    public synchronized Iterator<ClientRegistration> iterator() {
        return this._registrations.values().iterator();
    }

    public synchronized Mono<ClientRegistration> findByRegistrationId(String registrationId) {
        return Mono.justOrEmpty((Object)((ClientRegistration)this._registrations.get((Object)registrationId)));
    }

    private void addManager(String issuer) {
        try {
            ReactiveJwtDecoder decoder = ReactiveJwtDecoders.fromIssuerLocation((String)issuer);
            JwtReactiveAuthenticationManager manager = new JwtReactiveAuthenticationManager(decoder);
            String key = this.getHostResolverKeyFromIssuer(issuer);
            this._authenticationManagers.put(key, manager);
        }
        catch (RuntimeException e) {
            LOG.warn("Authentication manager for issuer-location " + issuer + " could not be added.", (Throwable)e);
        }
    }

    private void removeManager(String issuer) {
        String key = this.getHostResolverKeyFromIssuer(issuer);
        this._authenticationManagers.remove(key);
    }

    @Nonnull
    public Mono<ClientRegistration> findByClientId(String clientId, String issuer) {
        return Mono.justOrEmpty((Object)this._registrations.values().stream().filter(r -> r.getClientId().equals(clientId)).filter(r -> Objects.equals(this.getHostResolverKeyFromIssuer(r.getProviderDetails().getIssuerUri()), this.getHostResolverKeyFromIssuer(issuer))).findFirst().orElse(null));
    }

    @Nonnull
    public Mono<ReactiveAuthenticationManager> resolve(String issuer) {
        return Mono.justOrEmpty((Object)this.getHostResolverKeyFromIssuer(issuer)).filter(Predicate.not(String::isEmpty)).mapNotNull(this._authenticationManagers::get);
    }

    @CheckForNull
    private String getHostResolverKeyFromIssuer(@Nullable String issuer) {
        if (issuer == null) {
            return null;
        }
        try {
            return new URL(issuer).getHost();
        }
        catch (MalformedURLException e) {
            LOG.warn("malformed issuer: " + issuer, (Throwable)e);
            return null;
        }
    }

    public void save(ClientRegistration registration) {
        HashMap<String, ClientRegistration> tmpMap = new HashMap<String, ClientRegistration>((Map<String, ClientRegistration>)this._registrations);
        tmpMap.put(registration.getRegistrationId(), registration);
        this._registrations = ImmutableMap.copyOf(tmpMap);
        String issuerUri = registration.getProviderDetails().getIssuerUri();
        if (!Strings.isNullOrEmpty((String)issuerUri)) {
            this.addManager(issuerUri);
        }
        this.updateEntryPoint();
    }

    private void updateEntryPoint() {
        this._justOauthLoginAuthenticationEntryPoint.setDefaultIdp(this.getDefaultDesktopClient());
        this._externalIdpConfigured = this.getDefaultDesktopClient() != null;
    }

    public void delete(String key) {
        HashMap tmpMap = new HashMap(this._registrations);
        ClientRegistration deleted = (ClientRegistration)tmpMap.remove(key);
        this._registrations = ImmutableMap.copyOf(tmpMap);
        if (deleted != null && !Strings.isNullOrEmpty((String)deleted.getProviderDetails().getIssuerUri())) {
            this.removeManager(deleted.getProviderDetails().getIssuerUri());
        }
        this.updateEntryPoint();
    }

    @Nonnull
    public ClientRegistration getJustMobileClientRegistration() {
        return Objects.requireNonNull((ClientRegistration)this._registrations.get((Object)"just_mobile"));
    }

    @Nonnull
    public ClientRegistration getMobileClientRegistrationForTarget(ClientTarget target) {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)target)).filter(r -> !JustLoginHelper.isJustIdp((String)r.getRegistrationId())).findFirst().orElse(this.getJustMobileClientRegistration());
    }

    @Nonnull
    public Set<ClientRegistration> getAllDesktopClients() {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).collect(Collectors.toUnmodifiableSet());
    }

    @CheckForNull
    private ClientRegistration getDefaultDesktopClient() {
        return this._registrations.values().stream().filter(JustInMemoryClientRegistrationRepository.clientsForTarget((ClientTarget)ClientTarget.DESKTOP)).filter(r -> !JustLoginHelper.isJustIdp((String)r.getRegistrationId())).filter(JustInMemoryClientRegistrationRepository::isDefault).findFirst().orElse(null);
    }

    public boolean isDesktopIdpConfigured() {
        return this._externalIdpConfigured;
    }
}

