/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.monitoring;

import de.justsoftware.gateway.monitoring.GatewayRouteHealthIndicator;
import de.justsoftware.gateway.monitoring.GatewayRouteHealthIndicatorConfiguration;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;

@ConditionalOnWebApplication
@Configuration
@ParametersAreNonnullByDefault
public class GatewayRouteHealthIndicatorConfiguration
implements ApplicationListener<ApplicationPreparedEvent> {
    private final RouteLocator _routeLocator;
    private final ReactiveHealthContributorRegistry _healthContributorRegistry;

    public GatewayRouteHealthIndicatorConfiguration(RouteLocator routeLocator, ReactiveHealthContributorRegistry healthContributorRegistry) {
        this._routeLocator = routeLocator;
        this._healthContributorRegistry = healthContributorRegistry;
    }

    public void onApplicationEvent(ApplicationPreparedEvent event) {
        this._routeLocator.getRoutes().filter(arg_0 -> this.monitoringEnabled(arg_0)).map(GatewayRouteHealthIndicator::new).collectList().doOnSuccess(indicators -> {
            RoutingCompositeReactiveHealthContributor routesContributor = new RoutingCompositeReactiveHealthContributor(indicators);
            this._healthContributorRegistry.registerContributor("routes", (Object)routesContributor);
        }).subscribe();
    }

    private boolean monitoringEnabled(Route route) {
        return Boolean.parseBoolean(route.getMetadata().getOrDefault("monitoring-enabled", "true").toString());
    }
}

