/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.monitoring;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientRequest;

@ParametersAreNonnullByDefault
public class GatewayRouteHealthIndicator
extends AbstractReactiveHealthIndicator {
    private final LoadingCache<Route, Mono<Health>> _healthCheckCache;
    private final Route _route;

    public GatewayRouteHealthIndicator(Route route) {
        this._route = route;
        this._healthCheckCache = Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(10L)).refreshAfterWrite(Duration.ofSeconds(5L)).build(arg_0 -> this.checkRoute(arg_0));
        this.checkRoute(this._route).subscribe();
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        return (Mono)this._healthCheckCache.get((Object)this._route);
    }

    @Nonnull
    private Mono<Health> checkRoute(Route route) {
        WebClient client = WebClient.builder().baseUrl(route.getUri().toString()).build();
        String uri = route.getMetadata().getOrDefault("monitoring-uri", "/internal/monitoring/health").toString();
        return client.get().uri(uri, new Object[0]).httpRequest(request -> {
            HttpClientRequest nativeRequest = (HttpClientRequest)request.getNativeRequest();
            nativeRequest.responseTimeout(Duration.ofSeconds(2L));
        }).retrieve().onStatus(HttpStatus::is5xxServerError, clientResponse -> Mono.empty()).bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(body -> {
            String stringStatus = body.getOrDefault("status", "UP").toString();
            return Health.status((String)stringStatus).withDetails(body).build();
        }).onErrorResume(throwable -> Mono.just((Object)Health.down().withException(throwable).build()));
    }

    @Nonnull
    public Route getRoute() {
        return this._route;
    }
}

