/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.controller;

import de.justsoftware.gateway.security.ErrorCode;
import de.justsoftware.gateway.security.oauth2.JustInMemoryClientRegistrationRepository;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@ParametersAreNonnullByDefault
public class LoginLogoutController {
    public static final String OAUTH_2_LOGIN_PAGE = "/oauth2/login";
    private final JustInMemoryClientRegistrationRepository _idpClientRepo;

    public LoginLogoutController(JustInMemoryClientRegistrationRepository idpClientRepo) {
        this._idpClientRepo = idpClientRepo;
    }

    @Nonnull
    @GetMapping(value={"/oauth2/login"})
    public String login(Model model, @Nullable @RequestParam(value="errorCode", required=false) ErrorCode errorCode, ServerHttpResponse response) {
        if (errorCode != null) {
            response.setStatusCode(errorCode.getHttpStatus());
            model.addAttribute("errorCode", (Object)errorCode);
        } else {
            model.addAttribute("idps", (Object)this.getDesktopIdps());
        }
        return "login";
    }

    @Nonnull
    @GetMapping(value={"/just/loggedOut"})
    public String loggedOut() {
        return "loggedOut";
    }

    @Nonnull
    private List<ClientRegistration> getDesktopIdps() {
        return this._idpClientRepo.getAllDesktopClients().stream().sorted(Comparator.comparing(ClientRegistration::getClientName)).collect(Collectors.toList());
    }
}

