/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.base.Objects;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.rest.models.Person;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class PublicLink {
    private final String _id;
    private final DocumentId _documentId;
    private final DateTime _expirationDate;
    private final Person _creator;
    private final DateTime _creationDate;
    private final String _url;

    public PublicLink(String id, DocumentId documentId, @Nullable DateTime expirationDate, Person creator, DateTime creationDate, String url) {
        this._id = id;
        this._documentId = documentId;
        this._expirationDate = expirationDate;
        this._creator = creator;
        this._creationDate = creationDate;
        this._url = url;
    }

    @Nonnull
    public String getId() {
        return this._id;
    }

    @Nonnull
    public DocumentId getDocumentId() {
        return this._documentId;
    }

    @CheckForNull
    public DateTime getExpirationDate() {
        return this._expirationDate;
    }

    @Nonnull
    public Person getCreator() {
        return this._creator;
    }

    @Nonnull
    public String getUrl() {
        return this._url;
    }

    @Nonnull
    public DateTime getCreationDate() {
        return this._creationDate;
    }

    @Nonnull
    private Object[] getHashObjects() {
        return new Object[]{this._id, this._documentId, this._expirationDate, this._creator, this._creationDate, this._url};
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj instanceof PublicLink && Arrays.equals(this.getHashObjects(), ((PublicLink)obj).getHashObjects());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])this.getHashObjects());
    }
}

