/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Item {
    private final ItemId _itemId;
    private final ItemId _parentItemId;
    private final String _name;
    private final ImmutableSet<StaticAction> _allowedActions;

    public Item(ItemId itemId) {
        this(itemId, null, null, ImmutableSet.of());
    }

    public Item(ItemId itemId, String name) {
        this(itemId, null, name, ImmutableSet.of());
    }

    public Item(ItemId itemId, @Nullable ItemId parentItemId, @Nullable String name, ImmutableSet<StaticAction> allowedActions) {
        this._itemId = itemId;
        this._parentItemId = parentItemId;
        this._name = name;
        this._allowedActions = allowedActions;
    }

    @Nonnull
    public ItemId getItemId() {
        return this._itemId;
    }

    @CheckForNull
    public ItemId getParentItemId() {
        return this._parentItemId;
    }

    @CheckForNull
    public String getName() {
        return this._name;
    }

    @Nonnull
    @Schema(description="A set of all the actions the current user is allowed to conduct on the item")
    public ImmutableSet<StaticAction> getAllowedActions() {
        return this._allowedActions;
    }
}

