/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.rest.models.DocumentListEntry;
import de.justsoftware.drive.rest.models.Person;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Schema
public abstract class Document
implements DocumentListEntry {
    private final DocumentId _id;
    private final String _name;
    private final Person _owner;
    private final DateTime _lastModified;
    private final DocumentVersionId _versionId;
    private final int _version;
    private final ImmutableSet<StaticAction> _allowedActions;
    private final DocumentId _parentFolderId;
    private final boolean _publicLinksAvailable;
    private final boolean _public;

    Document(DocumentId id, DocumentVersionId versionId, String name, Person owner, DateTime lastModified, int version, ImmutableSet<StaticAction> allowedActions, @Nullable DocumentId parentFolderId, boolean publicLinksAvailable, boolean isPublic) {
        this._id = id;
        this._versionId = versionId;
        this._name = name;
        this._owner = owner;
        this._lastModified = lastModified;
        this._version = version;
        this._allowedActions = allowedActions;
        this._parentFolderId = parentFolderId;
        this._publicLinksAvailable = publicLinksAvailable;
        this._public = isPublic;
    }

    @Schema(required=true)
    @Nonnull
    public DocumentId getId() {
        return this._id;
    }

    @Schema(required=true)
    @Nonnull
    public DocumentVersionId getVersionId() {
        return this._versionId;
    }

    @Schema(required=true)
    @Nonnull
    public String getName() {
        return this._name;
    }

    @Schema(required=true)
    @Nonnull
    public Person getOwner() {
        return this._owner;
    }

    @Schema(description="The date of the last modification of this document", required=true)
    @Nonnull
    public DateTime getLastModified() {
        return this._lastModified;
    }

    public int getVersion() {
        return this._version;
    }

    @Schema(description="the set of allowed actions", required=true)
    @Nonnull
    public ImmutableSet<StaticAction> getAllowedActions() {
        return this._allowedActions;
    }

    @Schema(description="the id of the parent folder of the document, null for root folders", required=false)
    @CheckForNull
    public DocumentId getParentFolderId() {
        return this._parentFolderId;
    }

    @Schema(description="if a document version is public or not")
    public boolean isPublic() {
        return this._public;
    }

    @Schema(description="whether there are public links for this document set.")
    public boolean isPublicLinksAvailable() {
        return this._publicLinksAvailable;
    }
}

