/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.google.common.collect.ImmutableList;
import de.justsoftware.drive.rest.config.JustOpaqueTokenIntrospector;
import de.justsoftware.jwtfilter.JwtAuthenticationProcessingFilter;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;

@Configuration
@EnableWebSecurity
@ParametersAreNonnullByDefault
public class RestSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String INTERNAL_API = "/internal/**";
    private static final String FILESYNC_API = "/sync/**";
    private static final String PUBLIC_LINK_API = "/s/**";
    private static final String UNAUTHENTICATED_API = "/api/unauthenticated/**";
    private static final String[] SWAGGER_RESOURCES = new String[]{"/swagger/**", "/configuration/**", "/swagger-resources/**", "/swagger-ui/**", "/webjars/**", "/v3/api-docs/**"};
    private static final OrRequestMatcher JWT_IGNORE_PATH_MATCHER = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/internal/**"), (Object)new AntPathRequestMatcher("/sync/**"), (Object)new AntPathRequestMatcher("/s/**"), (Object)new AntPathRequestMatcher("/api/unauthenticated/**")));
    private static final OrRequestMatcher ALLOW_COOKIE_ONLY_AUTH = new OrRequestMatcher((List)ImmutableList.of((Object)new AntPathRequestMatcher("/api/previews/**"), (Object)new AntPathRequestMatcher("/api/documents/folder/*/zip"), (Object)new AntPathRequestMatcher("/api/documents/fileversion/*/download"), (Object)new AntPathRequestMatcher("/api/documents/*/download")));
    private final JwtAuthenticationProcessingFilter _jwtAuthenticationProcessingFilter;
    private final JustOpaqueTokenIntrospector _justOpaqueTokenIntrospector;

    @Autowired
    public RestSecurityConfig(JwtAuthenticationProcessingFilter jwtAuthenticationProcessingFilter, JustOpaqueTokenIntrospector justOpaqueTokenIntrospector) {
        super(true);
        this._jwtAuthenticationProcessingFilter = jwtAuthenticationProcessingFilter;
        this._justOpaqueTokenIntrospector = justOpaqueTokenIntrospector;
    }

    public void configure(HttpSecurity http) throws Exception {
        this._jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher(arg_0 -> ((OrRequestMatcher)JWT_IGNORE_PATH_MATCHER).matches(arg_0)).applyAllowCookieOnlyVerificationMatcher(arg_0 -> ((OrRequestMatcher)ALLOW_COOKIE_ONLY_AUTH).matches(arg_0));
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).exceptionHandling().and()).anonymous().and()).servletApi().and()).headers().cacheControl().and().and()).authorizeRequests().antMatchers(new String[]{INTERNAL_API, FILESYNC_API, PUBLIC_LINK_API, UNAUTHENTICATED_API})).permitAll().and()).authorizeRequests().antMatchers(SWAGGER_RESOURCES)).permitAll().and()).authorizeRequests().anyRequest()).authenticated().and()).oauth2ResourceServer().opaqueToken(c -> c.introspector((OpaqueTokenIntrospector)this._justOpaqueTokenIntrospector)).and()).addFilterAfter((Filter)this._jwtAuthenticationProcessingFilter, AbstractPreAuthenticatedProcessingFilter.class).csrf().disable();
    }
}

