/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.google.common.collect.ImmutableList;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.MicroblogEntryId;
import de.justsoftware.drive.common.file.model.TempFileId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractUUIDBasedId;
import de.justsoftware.drive.common.model.LongId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.rest.mapping.AbstractUUIDBasedIdKeySerializer;
import de.justsoftware.drive.rest.mapping.AbstractUUIDBasedIdSerializer;
import de.justsoftware.drive.rest.mapping.DocumentIdCustomEditor;
import de.justsoftware.drive.rest.mapping.DocumentIdDeserializer;
import de.justsoftware.drive.rest.mapping.DocumentVersionIdCustomEditor;
import de.justsoftware.drive.rest.mapping.ItemIdCustomEditor;
import de.justsoftware.drive.rest.mapping.ItemIdSerializer;
import de.justsoftware.drive.rest.mapping.LongIdSerializer;
import de.justsoftware.drive.rest.mapping.MicroblogEntryIdSerializer;
import de.justsoftware.drive.rest.mapping.PersonIdCustomEditor;
import de.justsoftware.drive.rest.mapping.PersonIdDeserializer;
import de.justsoftware.drive.rest.mapping.PersonIdKeyDeserializer;
import de.justsoftware.drive.rest.mapping.PersonIdKeySerializer;
import de.justsoftware.drive.rest.mapping.TempFileIdCustomEditor;
import de.justsoftware.drive.rest.mapping.TempFileIdDeserializer;
import de.justsoftware.drive.rest.mapping.UserGroupIdDeserializer;
import java.beans.PropertyEditor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.client.RestTemplate;

@Configuration
@ControllerAdvice
@ParametersAreNonnullByDefault
public class DriveObjectMappingConfig {
    @Bean
    @Primary
    @Nonnull
    public MappingJackson2HttpMessageConverter jackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter(new Jackson2ObjectMapperBuilder().modules(new Module[]{this.jodaModule(), this.driveIdMappingModule()}).serializationInclusion(JsonInclude.Include.NON_NULL).build());
    }

    @Bean
    @Primary
    @Nonnull
    public RestTemplate defaultRestTemplate(@Qualifier(value="jackson2HttpMessageConverter") MappingJackson2HttpMessageConverter messageConverter) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        restTemplate.setMessageConverters((List)ImmutableList.of((Object)messageConverter, (Object)new StringHttpMessageConverter()));
        return restTemplate;
    }

    @Nonnull
    public Module jodaModule() {
        return new JodaModule();
    }

    @Nonnull
    public Module driveIdMappingModule() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(AbstractUUIDBasedId.class, (JsonSerializer)new AbstractUUIDBasedIdSerializer());
        module.addSerializer(MicroblogEntryId.class, (JsonSerializer)new MicroblogEntryIdSerializer());
        module.addSerializer(LongId.class, (JsonSerializer)new LongIdSerializer());
        module.addSerializer(ItemId.class, (JsonSerializer)new ItemIdSerializer());
        module.addDeserializer(DocumentId.class, (JsonDeserializer)new DocumentIdDeserializer());
        module.addDeserializer(PersonId.class, (JsonDeserializer)new PersonIdDeserializer());
        module.addDeserializer(TempFileId.class, (JsonDeserializer)new TempFileIdDeserializer());
        module.addDeserializer(UserGroupId.class, (JsonDeserializer)new UserGroupIdDeserializer());
        module.addDeserializer(String.class, (JsonDeserializer)new StringDeserializer());
        module.addKeySerializer(AbstractUUIDBasedId.class, (JsonSerializer)new AbstractUUIDBasedIdKeySerializer());
        module.addKeySerializer(PersonId.class, (JsonSerializer)new PersonIdKeySerializer());
        module.addKeyDeserializer(PersonId.class, (KeyDeserializer)new PersonIdKeyDeserializer());
        return module;
    }

    @InitBinder
    public void initBinder(WebDataBinder dataBinder) {
        dataBinder.registerCustomEditor(DocumentId.class, (PropertyEditor)new DocumentIdCustomEditor());
        dataBinder.registerCustomEditor(DocumentVersionId.class, (PropertyEditor)new DocumentVersionIdCustomEditor());
        dataBinder.registerCustomEditor(ItemId.class, (PropertyEditor)new ItemIdCustomEditor());
        dataBinder.registerCustomEditor(PersonId.class, (PropertyEditor)new PersonIdCustomEditor());
        dataBinder.registerCustomEditor(TempFileId.class, (PropertyEditor)new TempFileIdCustomEditor());
    }
}

