/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.item;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface ItemDAO {
    public void setParents(Map<ItemId, Optional<ItemId>> var1);

    public void setNames(Map<ItemId, String> var1);

    @CheckForNull
    default public ItemBO findItem(ItemId itemId) {
        return (ItemBO)this.getItems(Set.of(itemId)).getOrDefault((Object)itemId, null);
    }

    @Nonnull
    public ImmutableMap<ItemId, ItemBO> getItems(Set<ItemId> var1);

    @Nonnull
    public ImmutableSetMultimap<ItemId, ItemId> getChildren(Set<ItemId> var1);

    public void markAsDeleted(Set<ItemId> var1);

    public void storeItems(Map<ItemId, ItemCreateModel> var1);

    public int forAllItemsWithDocuments(int var1, Consumer<List<ItemId>> var2);

    public void forEachItemWithAtLeastNChanges(int var1, Consumer<ItemId> var2);

    public int forAllShares(Consumer<ItemBO> var1);

    @Nonnull
    public Set<ItemId> getDeletedItems(ItemType var1, Duration var2);

    @Nonnull
    public Set<ItemId> filterDeleted(Set<ItemId> var1);

    public void deleteItems(Set<ItemId> var1);

    @Nonnull
    public Set<ItemId> filterChildFree(Set<ItemId> var1);
}

