/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.change;

import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.change.model.ChangeVersionUpdateModel;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.change.ChangeCreateModel;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
@Mapper
public interface ChangeMapper {
    public static final String CHANGE_BO_MAP = "ChangeBoMap";
    public static final String CHANGE_BO_COLS = "folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date";

    @Insert(value={"INSERT INTO change(folder_version_id, item_id, version, first_published_date)", "VALUES (#{_folderVersionId}, #{_itemId}, #{_version}, #{_firstPublishedDate})"})
    public void insertChange(ChangeCreateModel var1);

    @ResultType(value=ChangeBO.class)
    @ConstructorArgs(value={@Arg(column="folder_version_id", javaType=DocumentVersionId.class), @Arg(column="item_id", javaType=ItemId.class), @Arg(column="version", javaType=int.class), @Arg(column="first_version", javaType=String.class), @Arg(column="first_published_version", javaType=String.class), @Arg(column="first_published_date", javaType=DateTime.class), @Arg(column="expiration_date", javaType=DateTime.class)})
    @Select(value={"<script>", "SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "FROM (", "  SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "  , RANK() OVER (PARTITION BY item_id ORDER BY version", "<if test=\"initialChangeFirst\">ASC</if>", "<if test=\"!initialChangeFirst\">DESC</if>", ") AS rank FROM change", "  WHERE item_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "  <if test=\"filterPublicOnly\">AND first_published_date IS NOT NULL</if>", ") ranked_change WHERE RANK = #{nth}", "</script>"})
    @Results(id="ChangeBoMap")
    public void getNthChange(ResultHandler<ChangeBO> var1, @Param(value="ids") List<ItemId> var2, @Param(value="nth") int var3, @Param(value="filterPublicOnly") boolean var4, @Param(value="initialChangeFirst") boolean var5);

    @ResultType(value=ChangeBO.class)
    @ResultMap(value={"ChangeBoMap"})
    @Select(value={"<script>", "SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "FROM change", "WHERE folder_version_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void getChangesByIds(ResultHandler<ChangeBO> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @ResultType(value=ChangeBO.class)
    @ResultMap(value={"ChangeBoMap"})
    @Select(value={"<script>", "SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "FROM change ORDER BY item_id ASC, version ASC", "</script>"})
    public void getAllChanges(ResultHandler<ChangeBO> var1);

    @ResultType(value=ChangeBO.class)
    @ResultMap(value={"ChangeBoMap"})
    @Select(value={"SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "FROM change", "WHERE item_id = #{id}", "ORDER BY version"})
    @Nonnull
    public List<ChangeBO> getAllChangesForItem(@Param(value="id") ItemId var1);

    @ResultType(value=ItemId.class)
    @Select(value={"SELECT DISTINCT item_id", "FROM change"})
    @Nonnull
    public List<ItemId> getAllItemIds();

    @Update(value={"UPDATE change SET", "  first_version = #{firstVersion},", "  first_published_version = #{firstPublishedVersion},", "  first_published_date = #{firstPublishedDate},", "  expiration_date = #{expirationDate}", "WHERE folder_version_id = #{changeId}"})
    public void updateChangeVersion(ChangeVersionUpdateModel var1);

    @ResultType(value=ChangeBO.class)
    @ResultMap(value={"ChangeBoMap"})
    @Select(value={"<script>", "SELECT folder_version_id, item_id, version, first_version, first_published_version, first_published_date, expiration_date", "FROM change pub", "WHERE EXISTS (", "  SELECT 1 FROM change orig", "  WHERE orig.item_id = pub.item_id", "  AND orig.folder_version_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "  AND pub.version > orig.version", ")", "AND first_published_date IS NOT NULL", "</script>"})
    public void loadPublicChangesAfter(ResultHandler<ChangeBO> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT item_id, owner", "FROM (", "  SELECT c.item_id, d.owner, RANK() OVER (PARTITION BY item_id ORDER BY c.version ASC) AS rank", "  FROM change c JOIN document_version d ON c.folder_version_id = d.id", "  WHERE c.item_id IN (<foreach collection='itemIds' item='i' separator=','>#{i}</foreach>)", ") ranked_change WHERE RANK = 1", "</script>"})
    @Results(value={@Result(column="item_id", property="key", javaType=ItemId.class), @Result(column="owner", property="value", javaType=PersonId.class)})
    @ResultType(value=Map.class)
    public void loadAuthorsOfFirstChange(ResultHandler<Map<String, Object>> var1, @Param(value="itemIds") List<ItemId> var2);

    @Delete(value={"<script>DELETE FROM change", "WHERE folder_version_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteChanges(@Param(value="ids") List<DocumentVersionId> var1);

    @Delete(value={"<script>", "DELETE FROM change", "WHERE item_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    public void deleteChangesForItem(@Param(value="ids") List<ItemId> var1);

    @Select(value={"SELECT r.folder_version_id", "FROM change r", "JOIN change s ON r.item_id = s.item_id AND s.folder_version_id = #{start}", "JOIN change f ON r.item_id = f.item_id AND f.folder_version_id = #{end}", "WHERE r.version >= s.version AND r.version < f.version"})
    @ResultType(value=List.class)
    @Nonnull
    public List<DocumentVersionId> getIntermediateChanges(@Param(value="start") DocumentVersionId var1, @Param(value="end") DocumentVersionId var2);
}

