/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.authorization;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.authorization.PersonRoleDAO;
import de.justsoftware.drive.persistence.authorization.PersonRoleMapper;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class PersonRoleDAOImpl
implements PersonRoleDAO {
    private final PersonRoleMapper _personRoleMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public PersonRoleDAOImpl(PersonRoleMapper personRoleMapper, DAOSupport daoSupport) {
        this._personRoleMapper = personRoleMapper;
        this._daoSupport = daoSupport;
    }

    public void addRoles(SetMultimap<PersonId, Role> roles) {
        roles.forEach((personId, role) -> this._personRoleMapper.insert(personId, role, role.isStatic()));
    }

    public void removeRoles(SetMultimap<PersonId, Role> roles) {
        this._daoSupport.partition(roles.entries()).noResult(arg_0 -> ((PersonRoleMapper)this._personRoleMapper).delete(arg_0));
    }

    public ImmutableSetMultimap<PersonId, Role> hasRoles(SetMultimap<PersonId, Role> rolesToCheck) {
        return this._daoSupport.partition(rolesToCheck.entries()).asSetMultimap((arg_0, arg_1) -> ((PersonRoleMapper)this._personRoleMapper).hasRoles(arg_0, arg_1));
    }

    public ImmutableSetMultimap<Role, PersonId> getPersonWithRoles(Set<? extends Role> roles) {
        return this._daoSupport.partition(roles).asSetMultimap((arg_0, arg_1) -> ((PersonRoleMapper)this._personRoleMapper).getPersonWithRoles(arg_0, arg_1));
    }
}

