/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.authorization;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.drive.common.authorization.model.Action;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.authorization.ItemAction;
import de.justsoftware.drive.persistence.authorization.ItemActionDAO;
import de.justsoftware.drive.persistence.authorization.ItemActionsMapper;
import de.justsoftware.toolbox.ObjectUtil;
import de.justsoftware.toolbox.mybatis.DAOSupport;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class ItemActionsDAOImpl
implements ItemActionDAO {
    private final ItemActionsMapper _itemActionsMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public ItemActionsDAOImpl(ItemActionsMapper itemActionsMapper, DAOSupport daoSupport) {
        this._itemActionsMapper = itemActionsMapper;
        this._daoSupport = daoSupport;
    }

    public void insertItemActions(Table<ItemId, ? extends Action, String> actions) {
        for (Table.Cell c : actions.cellSet()) {
            ItemId row = (ItemId)ObjectUtil.checkNotNull((Object)((ItemId)c.getRowKey()));
            Action column = (Action)ObjectUtil.checkNotNull((Object)((Action)c.getColumnKey()));
            String value = (String)ObjectUtil.checkNotNull((Object)((String)c.getValue()));
            this._itemActionsMapper.insertAction(row, column, value);
        }
    }

    public void deleteItemActions(Set<ItemId> items) {
        for (ItemId i : items) {
            this._itemActionsMapper.deleteActions(i);
        }
    }

    public ImmutableTable<ItemId, Action, String> getItemActions(SetMultimap<ItemId, ? extends Action> actions) {
        return this._daoSupport.partition(actions.entries()).asTable((arg_0, arg_1) -> ((ItemActionsMapper)this._itemActionsMapper).getItemActions(arg_0, arg_1));
    }

    public int forAllShareActions(Consumer<ItemAction> consumer) {
        return this._daoSupport.forAll(consumer, arg_0 -> ((ItemActionsMapper)this._itemActionsMapper).forAllShareActions(arg_0));
    }
}

