/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.document.DocumentMigrationService;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.document.impl.DocumentMigrationConsumer;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.io.IOException;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StopWatch;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
@Service
public class DocumentMigrationConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final int MIGRATION_CHUNK_SIZE = 10;
    private static final String TOPIC_NAME = "just.migration.documents";
    private static final String DRIVE_DOCUMENT_ITEM_ID_PREVFIX = "DRIVE_DOCUMENT,";
    private static final Logger MIGRATION_LOG = DocumentMigrationService.MIGRATION_LOG;
    private final DocumentMigrationService _documentMigrationService;
    private final ItemLockService _itemLockService;

    @Autowired
    public DocumentMigrationConsumer(KafkaConfigurationProvider kafkaProvider, TransactionSupport transactionSupport, DocumentMigrationService migrationService, ItemLockService itemLockService) {
        super(kafkaProvider.stringConsumer("just.drive.migrationConsumer", 10), transactionSupport, "just.migration.documents");
        this._documentMigrationService = migrationService;
        this._itemLockService = itemLockService;
    }

    protected Logger getLog() {
        return MIGRATION_LOG;
    }

    protected void process(ConsumerRecords<String, String> records, Consumer<Runnable> afterCommitCallback) {
        if (!this._documentMigrationService.migrationPossible()) {
            throw new IllegalStateException("migration currently not possible");
        }
        MIGRATION_LOG.debug("start processing {} records", (Object)records.count());
        StopWatch watch = new StopWatch();
        watch.start();
        ImmutableList.Builder fileBuilder = ImmutableList.builder();
        ImmutableList.Builder metadataBuilder = ImmutableList.builder();
        records.forEach(r -> {
            String key = (String)r.key();
            String value = (String)r.value();
            if (key.startsWith("DOCUMENT_VERSION,") || key.endsWith("#version")) {
                try {
                    fileBuilder.add((Object)DocumentMigrationConsumer.transformToMigrationFile((MigratedVersion)((MigratedVersion)OBJECT_MAPPER.readValue(value, MigratedVersion.class))));
                }
                catch (IOException e) {
                    MIGRATION_LOG.error("value could not be parsed, skipping " + key + " - value " + value, (Throwable)e);
                }
            } else if (key.startsWith("DOCUMENT,") || key.endsWith("#document")) {
                try {
                    metadataBuilder.add((Object)((MigratedDocument)OBJECT_MAPPER.readValue(value, MigratedDocument.class)).toMigrationMetadata());
                }
                catch (IOException e) {
                    MIGRATION_LOG.error("document metadata could not be parsed, skipping " + key + " value " + value, (Throwable)e);
                }
            } else {
                MIGRATION_LOG.error("unknown key format {} - {}", (Object)key, (Object)value);
            }
        });
        ImmutableList filesToMigrate = fileBuilder.build();
        ImmutableList metadataToMigrate = metadataBuilder.build();
        ImmutableSet items = (ImmutableSet)Stream.concat(filesToMigrate.stream().map(f -> f._parentId), metadataToMigrate.stream().map(m -> m._parentId)).collect(ImmutableSet.toImmutableSet());
        this._itemLockService.acquireAndExecute((Set)items, () -> {
            this._documentMigrationService.addFilesFromMigration((Iterable)filesToMigrate, afterCommitCallback);
            this._documentMigrationService.updateMetadata((Iterable)metadataToMigrate);
            return this;
        });
        watch.stop();
        MIGRATION_LOG.info("processing done: {}", (Object)watch.shortSummary());
    }

    @Nonnull
    private static DocumentMigrationService.MigrationFile transformToMigrationFile(MigratedVersion version) {
        DocumentId documentId = new DocumentId(version._driveDocumentId.substring("DRIVE_DOCUMENT,".length()));
        DocumentVersionId versionId = new DocumentVersionId(version._driveVersionId);
        PersonId ownerId = new PersonId(version._owner);
        DateTime uploadedAt = DateTime.parse((String)version._uploadedAt);
        ItemId parentId = new ItemId(version._parentId);
        PreviewId previewId = version._previewId != null ? new PreviewId(version._previewId) : null;
        ItemId workstreamMessageId = version._workstreamMessageId != null ? new ItemId(version._workstreamMessageId) : null;
        Optional restordFromVersionId = version._restoredFromVersionId != null ? Optional.of((Object)new DocumentVersionId(version._restoredFromVersionId)) : Optional.absent();
        return new DocumentMigrationService.MigrationFile(documentId, versionId, (ItemId)MoreObjects.firstNonNull((Object)workstreamMessageId, (Object)parentId), version._version, version._fileName, version._storageServerPath, uploadedAt, ownerId, version._mimeType, version._fileSize, previewId, version._originId, (ItemId)(workstreamMessageId != null ? parentId : null), restordFromVersionId);
    }
}

