/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="drive.upload")
@RefreshScope
@ParametersAreNonnullByDefault
public class FileUploadConfigProperties {
    private static final DataSize DEFAULT_UPLOAD_MAX_FILE_SIZE = DataSize.ofMegabytes((long)250L);
    private Set<MimeType> _allowedMimeTypes = Set.of();
    private DataSize _uploadMaxFileSize = DEFAULT_UPLOAD_MAX_FILE_SIZE;

    @Nonnull
    public DataSize getUploadMaxFileSize() {
        return this._uploadMaxFileSize;
    }

    public void setUploadMaxFileSize(DataSize uploadMaxFileSize) {
        this._uploadMaxFileSize = uploadMaxFileSize;
    }

    @Nonnull
    public Set<MimeType> getAllowedMimeTypes() {
        return this._allowedMimeTypes;
    }

    public void setAllowedMimeTypes(String[] allowedMimeTypes) {
        this._allowedMimeTypes = Arrays.stream(allowedMimeTypes).map(MimeTypeUtils::parseMimeType).collect(Collectors.toSet());
    }
}

