/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.search;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.drive.batch.search.IndexRequirementsCollector;
import de.justsoftware.drive.batch.search.IndexerData;
import de.justsoftware.drive.batch.search.SearchIndexPublisher;
import de.justsoftware.drive.batch.search.SolrDocumentWrapper;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public enum SearchIndexFieldGroup {
    DOCUMENT_VERSION/* Unavailable Anonymous Inner Class!! */,
    DOCUMENT/* Unavailable Anonymous Inner Class!! */,
    ITEM/* Unavailable Anonymous Inner Class!! */,
    OWNER/* Unavailable Anonymous Inner Class!! */,
    PARENT_FOLDER/* Unavailable Anonymous Inner Class!! */,
    NEWEST_PUBLIC_CHANGE_PER_ITEM/* Unavailable Anonymous Inner Class!! */,
    FIRST_PUBLIC_CHANGE/* Unavailable Anonymous Inner Class!! */,
    VISIBILITIES/* Unavailable Anonymous Inner Class!! */,
    ALL_VERSIONS/* Unavailable Anonymous Inner Class!! */,
    SUBSCRIPTIONS/* Unavailable Anonymous Inner Class!! */,
    INDIRECT_PARENTS/* Unavailable Anonymous Inner Class!! */,
    CONTENT/* Unavailable Anonymous Inner Class!! */;

    private static final ImmutableSetMultimap<SearchIndexType, SearchIndexFieldGroup> FIELD_GROUPS_PER_TYPE;

    public void setValues(SolrDocumentWrapper solrDocument, DocumentVersionBO documentVersion, IndexerData indexData) {
    }

    public void publish(DocumentVersionBO documentVersion, SearchIndexPublisher publisher) {
    }

    public void requirements(DocumentVersionBO documentVersion, IndexRequirementsCollector collector) {
    }

    @Nonnull
    public static ImmutableSet<SearchIndexFieldGroup> forIndexType(SearchIndexType type) {
        return FIELD_GROUPS_PER_TYPE.get((Object)type);
    }

    @Nonnull
    public static ImmutableSet<SearchIndexFieldGroup> forIndexType(Iterable<SearchIndexType> indexTypes) {
        return FluentIterable.from(indexTypes).transformAndConcat(SearchIndexFieldGroup::forIndexType).toSet();
    }

    @CheckForNull
    private static String formatDate(@Nullable DateTime date) {
        if (date == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(date.getMillis());
        return DateTimeFormatter.ISO_INSTANT.format(instant);
    }

    static {
        FIELD_GROUPS_PER_TYPE = ImmutableSetMultimap.builder().putAll((Object)SearchIndexType.ALL, (Object[])SearchIndexFieldGroup.values()).putAll((Object)SearchIndexType.EXPIRATION_DATE, (Object[])new SearchIndexFieldGroup[]{DOCUMENT_VERSION, NEWEST_PUBLIC_CHANGE_PER_ITEM}).putAll((Object)SearchIndexType.DELETE, (Object[])new SearchIndexFieldGroup[]{DOCUMENT_VERSION}).putAll((Object)SearchIndexType.METADATA, (Object[])new SearchIndexFieldGroup[]{DOCUMENT_VERSION, DOCUMENT, NEWEST_PUBLIC_CHANGE_PER_ITEM, ITEM, OWNER, PARENT_FOLDER, FIRST_PUBLIC_CHANGE, VISIBILITIES, ALL_VERSIONS}).build();
    }
}

