/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatReadDate;
import de.justsoftware.chat.persistence.model.DbChatReadDateAndCount;
import de.justsoftware.chat.persistence.model.DbUserChatUnreadCount;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.persistence.QueryHint;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H'J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0017J$\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0017J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u000e\u001a\u00020\u000fH'J&\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00072\u0006\u0010\u0014\u001a\u00020\rH'J*\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\rH\u0017J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u000b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0018\u001a\u00020\rH'J.\u0010\u001a\u001a\u001a\u0012\u0004\u0012\u00020\r\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001b0\u00160\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H\u0017J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u0007H'J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010!\u001a\u00020\"H'\u00a8\u0006#"}, d2={"Lde/justsoftware/chat/persistence/ChatReadDateRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatReadDate;", "Lde/justsoftware/chat/persistence/model/DbChatProfileId;", "deleteByChatIdIn", "", "chatIds", "", "Ljava/util/UUID;", "deleteByChatIds", "findChatsByUpdatedAtGreaterThanAndParticipantIds", "", "participantIds", "", "updatedAt", "Ljava/time/Instant;", "findChatsByUpdatedAtGreaterThanAndParticipantIdsIn", "getUnreadChatCountByTenantIdAndParticipantIdIn", "", "tenantId", "profileId", "readDateAndCountForUserInChats", "", "Lde/justsoftware/chat/persistence/model/DbChatReadDateAndCount;", "userId", "readDateAndCountForUserInChatsRaw", "unreadCountsForUsers", "", "userIds", "unreadCountsForUsersRaw", "Lde/justsoftware/chat/persistence/model/DbUserChatUnreadCount;", "usersEligibleForUnreadMail", "Ljava/util/stream/Stream;", "sendMailNotificationDefault", "", "chat-service"})
public interface ChatReadDateRepository
extends JpaRepository<DbChatReadDate, DbChatProfileId> {
    @Query(value="\n        SELECT DISTINCT\n          p.id\n        FROM DbChatParticipant cp\n          LEFT JOIN DbUserGroupMember ugm ON ugm.groupId = cp.participantId\n          JOIN DbProfile p ON (p.id = cp.participantId OR p.id = ugm.profileId) \n          LEFT JOIN DbChatReadDate crd ON crd.profileId = p.id AND crd.chatId = cp.chatId\n          LEFT JOIN DbMailSettings ms ON ms.profileId = p.id\n          JOIN DbChat c ON cp.chatId = c.id\n        WHERE\n          (crd.readDate IS NULL OR c.sortDate > crd.readDate)\n          AND (ms.lastMailDeliveryDate IS NULL OR c.sortDate > ms.lastMailDeliveryDate)\n          AND ((ms.mailDeliveryEnabled IS NULL AND :sendMailNotificationDefault = true) OR ms.mailDeliveryEnabled = true)\n        ")
    @QueryHints(value={@QueryHint(value="1000", name="org.hibernate.fetchSize")})
    @NotNull
    public Stream<String> usersEligibleForUnreadMail(boolean var1);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="unreadCountsForUsers(userIds)", imports={}))
    @Query(value="\n        SELECT DISTINCT\n          COALESCE(ugm.profileId, cp.participantId) AS profileId,\n          cp.chatId AS chatId,\n          COUNT(DISTINCT cm.id) AS unreadCount\n        FROM DbChatParticipant cp\n          LEFT JOIN DbUserGroupMember ugm ON ugm.groupId = cp.participantId\n          LEFT JOIN DbChatReadDate crd ON (crd.profileId = cp.participantId OR crd.profileId = ugm.profileId) AND crd.chatId = cp.chatId\n          JOIN DbChatMessage cm ON cp.chatId = cm.chatId\n        WHERE\n          cm.messageType IN ('USER_MESSAGE', 'DELETED_MESSAGE')\n          AND (crd.readDate IS NULL OR cm.createdAt > crd.readDate)\n          AND (cp.participantId IN :userIds OR ugm.profileId IN :userIds)\n        GROUP BY\n          COALESCE(ugm.profileId, cp.participantId),\n          cp.chatId\n        ")
    @NotNull
    public List<DbUserChatUnreadCount> unreadCountsForUsersRaw(@NotNull Iterable<String> var1);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<String, Map<UUID, Long>> unreadCountsForUsers(@NotNull Iterable<String> userIds) {
        void $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable list$iv$iv;
        Iterable p0;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(userIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (Iterable)element$iv$iv;
            boolean bl = false;
            list$iv$iv = this.unreadCountsForUsersRaw(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv;
            element$iv$iv = iterator.next();
            p0 = (DbUserChatUnreadCount)element$iv$iv;
            boolean bl = false;
            key$iv$iv = p0.getProfileId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$associateTo$iv$iv;
            void entry;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object2 = object;
            boolean bl3 = false;
            Iterable $this$associate$iv = (Iterable)entry.getValue();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable2 = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                DbUserChatUnreadCount it = (DbUserChatUnreadCount)element$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to((Object)it.getChatId(), (Object)it.getUnreadCount());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv2;
            object2.put(k, map);
        }
        return destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="readDateAndCountForUserInChats(chatIds, userId)", imports={}))
    @Query(value="\n        SELECT c.id AS chatId, r.readDate AS readDate, (\n            SELECT count(*)\n            FROM DbChatMessage\n            WHERE chatId = c.id\n            AND messageType IN ('USER_MESSAGE', 'DELETED_MESSAGE')\n            AND (r.readDate IS NULL OR createdAt > r.readDate)\n        ) AS unreadCount\n        FROM DbChat c\n        LEFT JOIN DbChatReadDate r ON r.chatId = c.id AND r.profileId = :userId\n        WHERE c.id IN :chatIds\n        ")
    @NotNull
    public List<DbChatReadDateAndCount> readDateAndCountForUserInChatsRaw(@NotNull Iterable<UUID> var1, @NotNull String var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Map<UUID, DbChatReadDateAndCount> readDateAndCountForUserInChats(@NotNull Iterable<UUID> chatIds2, @NotNull String userId) {
        void $this$associateByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(chatIds2, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.readDateAndCountForUserInChatsRaw((Iterable)it, userId);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void p0;
            DbChatReadDateAndCount bl = (DbChatReadDateAndCount)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl2 = false;
            map.put(p0.getChatId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    @Query(value="\n        SELECT COUNT(c)\n        FROM DbChat c\n        LEFT JOIN DbChatReadDate crd\n        ON ( c.id = crd.chatId AND crd.profileId = :profileId )\n        WHERE c.tenantId = :tenantId\n        AND c.lastMessageId IS NOT NULL\n        AND c.id IN ( \n            SELECT DISTINCT p.chatId\n            FROM DbChatParticipant p\n            WHERE p.participantId IN :participantIds\n        ) AND (\n            c.sortDate > crd.readDate\n            OR crd.readDate IS NULL\n        )\n    ")
    public int getUnreadChatCountByTenantIdAndParticipantIdIn(@NotNull UUID var1, @NotNull Iterable<String> var2, @NotNull String var3);

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findChatsByUpdatedAtGreaterThanAndParticipantIds(participantIds, readDate)", imports={}))
    @Query(value="\n        SELECT c.id\n        FROM DbChat c \n        JOIN DbChatReadDate crd ON c.id = crd.chatId\n        WHERE crd.updatedAt > :updatedAt\n        AND (c.type = 'MULTI_USER_CHAT' OR c.lastMessageId IS NOT NULL)\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = c.id\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<UUID> findChatsByUpdatedAtGreaterThanAndParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public List<UUID> findChatsByUpdatedAtGreaterThanAndParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant updatedAt) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)updatedAt, (String)"updatedAt");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findChatsByUpdatedAtGreaterThanAndParticipantIdsIn((Iterable)it, updatedAt);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByChatIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    @JvmDefault
    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds2) {
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(chatIds2, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            this.deleteByChatIdIn(p0);
        }
    }
}

