/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment_;
import de.justsoftware.chat.persistence.model.DbChatMessage_;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.PluralAttribute;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u0018\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0017J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002J\u0018\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageSpecifications;", "", "()V", "attachmentMimeTypePath", "Ljavax/persistence/criteria/Path;", "", "kotlin.jvm.PlatformType", "root", "Ljavax/persistence/criteria/Root;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "witCreatedAtGreaterThan", "Lorg/springframework/data/jpa/domain/Specification;", "createdAt", "Ljava/time/Instant;", "withAnyAttachment", "withAttachments", "filter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "withChatId", "chatId", "Ljava/util/UUID;", "withChatIdIn", "chatIds", "", "withCreatedAtLessThan", "withImageAttachment", "withMediaAttachment", "withUpdatedAtGreaterThan", "updatedAt", "withVideoAttachment", "chat-service"})
public final class ChatMessageSpecifications {
    @NotNull
    public static final ChatMessageSpecifications INSTANCE = new ChatMessageSpecifications();

    private ChatMessageSpecifications() {
    }

    @NotNull
    public final Specification<DbChatMessage> withChatId(@NotNull UUID chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatId$lambda-0(chatId, arg_0, arg_1, arg_2);
    }

    @NotNull
    public final Specification<DbChatMessage> withChatIdIn(@NotNull Collection<UUID> chatIds2) {
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        return (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withChatIdIn$lambda-1(chatIds2, arg_0, arg_1, arg_2);
    }

    @Nullable
    public final Specification<DbChatMessage> withCreatedAtLessThan(@Nullable Instant createdAt) {
        return createdAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withCreatedAtLessThan$lambda-2(createdAt, arg_0, arg_1, arg_2) : (Specification)null;
    }

    @Nullable
    public final Specification<DbChatMessage> witCreatedAtGreaterThan(@Nullable Instant createdAt) {
        return createdAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.witCreatedAtGreaterThan$lambda-3(createdAt, arg_0, arg_1, arg_2) : (Specification)null;
    }

    @Nullable
    public final Specification<DbChatMessage> withUpdatedAtGreaterThan(@Nullable Instant updatedAt) {
        return updatedAt != null ? (arg_0, arg_1, arg_2) -> ChatMessageSpecifications.withUpdatedAtGreaterThan$lambda-4(updatedAt, arg_0, arg_1, arg_2) : (Specification)null;
    }

    @Nullable
    public final Specification<DbChatMessage> withAttachments(@Nullable AttachmentFilter filter) {
        Specification specification;
        AttachmentFilter attachmentFilter = filter;
        switch (attachmentFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attachmentFilter.ordinal()]) {
            case 1: {
                specification = this.withImageAttachment();
                break;
            }
            case 2: {
                specification = this.withVideoAttachment();
                break;
            }
            case 3: {
                specification = this.withMediaAttachment();
                break;
            }
            case 4: {
                specification = Specification.not((Specification)this.withMediaAttachment());
                break;
            }
            case 5: {
                specification = this.withAnyAttachment();
                break;
            }
            case -1: {
                specification = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return specification;
    }

    private final Specification<DbChatMessage> withAnyAttachment() {
        return ChatMessageSpecifications::withAnyAttachment$lambda-5;
    }

    private final Specification<DbChatMessage> withImageAttachment() {
        return ChatMessageSpecifications::withImageAttachment$lambda-6;
    }

    private final Specification<DbChatMessage> withVideoAttachment() {
        return ChatMessageSpecifications::withVideoAttachment$lambda-7;
    }

    private final Specification<DbChatMessage> withMediaAttachment() {
        return ChatMessageSpecifications::withMediaAttachment$lambda-9;
    }

    private final Path<String> attachmentMimeTypePath(Root<DbChatMessage> root) {
        return root.join(DbChatMessage_.attachments).get(DbChatMessageAttachment_.mimeType);
    }

    private static final Predicate withChatId$lambda-0(UUID $chatId, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return criteriaBuilder.equal((Expression)root.get(DbChatMessage_.chatId), (Object)$chatId);
    }

    private static final Predicate withChatIdIn$lambda-1(Collection $chatIds, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullParameter((Object)$chatIds, (String)"$chatIds");
        return root.get(DbChatMessage_.chatId).in($chatIds);
    }

    private static final Predicate withCreatedAtLessThan$lambda-2(Instant $createdAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThan((Expression)root.get(DbChatMessage_.createdAt), (Comparable)$createdAt);
    }

    private static final Predicate witCreatedAtGreaterThan$lambda-3(Instant $createdAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get(DbChatMessage_.createdAt), (Comparable)$createdAt);
    }

    private static final Predicate withUpdatedAtGreaterThan$lambda-4(Instant $updatedAt, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)root.get(DbChatMessage_.updatedAt), (Comparable)$updatedAt);
    }

    private static final Predicate withAnyAttachment$lambda-5(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.isNotEmpty(root.get((PluralAttribute)DbChatMessage_.attachments));
    }

    private static final Predicate withImageAttachment$lambda-6(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        return INSTANCE.attachmentMimeTypePath(root).in((Collection)ChatMessageService.Companion.getIMAGE_FORMATS());
    }

    private static final Predicate withVideoAttachment$lambda-7(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        return criteriaBuilder.like((Expression)mimeTypePath, "video/%");
    }

    private static final Predicate withMediaAttachment$lambda-9(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In in;
        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        CriteriaBuilder.In $this$withMediaAttachment_u24lambda_u2d9_u24lambda_u2d8 = in = criteriaBuilder.in((Expression)mimeTypePath);
        boolean bl = false;
        Iterable $this$forEach$iv = ChatMessageService.Companion.getIMAGE_FORMATS();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            $this$withMediaAttachment_u24lambda_u2d9_u24lambda_u2d8.value((Object)p0);
        }
        CriteriaBuilder.In imagePredicate = in;
        Predicate videoPredicate = criteriaBuilder.like((Expression)mimeTypePath, "video/%");
        Predicate[] predicateArray = new Predicate[]{(Predicate)imagePredicate, videoPredicate};
        return criteriaBuilder.or(predicateArray);
    }
}

