/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.persistence.model.DbChatMessage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\bg\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00020\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH'J\u0016\u0010\t\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0017J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH'J$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0012\u001a\u00020\u0013H'J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0013H'\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageRepository;", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lde/justsoftware/chat/persistence/model/DbChatMessage;", "Ljava/util/UUID;", "Lorg/springframework/data/jpa/repository/JpaSpecificationExecutor;", "deleteByChatIdIn", "", "chatIds", "", "deleteByChatIds", "findAllUserMessages", "Lorg/springframework/data/domain/Page;", "pageable", "Lorg/springframework/data/domain/Pageable;", "findUpdatedAuthorsByParticipantIds", "", "", "participantIds", "since", "Ljava/time/Instant;", "findUpdatedAuthorsByParticipantIdsIn", "updateUpdatedAt", "", "id", "updatedAt", "chat-service"})
public interface ChatMessageRepository
extends JpaRepository<DbChatMessage, UUID>,
JpaSpecificationExecutor<DbChatMessage> {
    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="findUpdatedAuthorsByParticipantIds(participantIds, since)", imports={}))
    @Query(value="\n        SELECT p.id\n        FROM DbProfile p\n        JOIN DbChatMessage m ON p.id = m.author\n        WHERE p.updatedAt > :since\n        AND EXISTS (\n            SELECT 1\n            FROM DbChatParticipant cp\n            WHERE cp.chatId = m.chatId\n            AND cp.participantId IN :participantIds\n        )\n        ")
    @NotNull
    public List<String> findUpdatedAuthorsByParticipantIdsIn(@NotNull Iterable<String> var1, @NotNull Instant var2);

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public List<String> findUpdatedAuthorsByParticipantIds(@NotNull Iterable<String> participantIds, @NotNull Instant since) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable $this$flatMap$iv = CollectionsKt.chunked(participantIds, (int)1000);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List it = (List)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.findUpdatedAuthorsByParticipantIdsIn((Iterable)it, since);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Deprecated(message="Use chunked version.", replaceWith=@ReplaceWith(expression="deleteByChatIds(chatIds)", imports={}))
    public void deleteByChatIdIn(@NotNull Iterable<UUID> var1);

    @JvmDefault
    default public void deleteByChatIds(@NotNull Iterable<UUID> chatIds2) {
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Iterable $this$forEach$iv = CollectionsKt.chunked(chatIds2, (int)1000);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable p0 = (Iterable)element$iv;
            boolean bl = false;
            this.deleteByChatIdIn(p0);
        }
    }

    @Modifying
    @Query(value="UPDATE chat_message SET updated_at = :updatedAt WHERE id = :id", nativeQuery=true)
    @Transactional
    public int updateUpdatedAt(@NotNull UUID var1, @NotNull Instant var2);

    @Query(value="\n        SELECT m\n        FROM DbChatMessage m\n        WHERE m.messageType = 'USER_MESSAGE'\n        ORDER BY m.chatId, m.createdAt, m.id\n        ")
    @NotNull
    public Page<DbChatMessage> findAllUserMessages(@NotNull Pageable var1);
}

