/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.model;

import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/chat/mobile/model/MobileClientVersion;", "", "platform", "Lde/justsoftware/chat/mobile/model/MobileClientVersion$Platform;", "versionCode", "", "(Lde/justsoftware/chat/mobile/model/MobileClientVersion$Platform;J)V", "getPlatform", "()Lde/justsoftware/chat/mobile/model/MobileClientVersion$Platform;", "getVersionCode", "()J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "validate", "", "Companion", "Platform", "chat-service"})
public final class MobileClientVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Platform platform;
    private final long versionCode;
    @NotNull
    private static final MobileClientVersion UNKNOWN_CLIENT_VERSION = new MobileClientVersion(Platform.UNKNOWN, 0L);
    @NotNull
    private static final MobileClientVersion UNKNOWN_ANDROID_VERSION = new MobileClientVersion(Platform.ANDROID, -1L);
    @NotNull
    private static final MobileClientVersion UNKNOWN_IOS_VERSION = new MobileClientVersion(Platform.IOS, -1L);
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Regex ANDROID_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_VERSION_CODE_REGEX;
    @NotNull
    private static final Regex IOS_APP_VERSION_REGEX;

    public MobileClientVersion(@NotNull Platform platform, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform = platform;
        this.versionCode = versionCode;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    public final long getVersionCode() {
        return this.versionCode;
    }

    public final void validate() {
        ValidationException.Companion companion = ValidationException.Companion;
        boolean value$iv = this.versionCode >= this.platform.getMinVersion();
        boolean $i$f$validate = false;
        if (!value$iv) {
            boolean bl = false;
            String string2 = ("The app version code is too low. Found version " + this.versionCode + ", min version for " + this.platform + " is " + this.platform.getMinVersion()).toString();
            throw new ValidationException(string2);
        }
    }

    @NotNull
    public final Platform component1() {
        return this.platform;
    }

    public final long component2() {
        return this.versionCode;
    }

    @NotNull
    public final MobileClientVersion copy(@NotNull Platform platform, long versionCode) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return new MobileClientVersion(platform, versionCode);
    }

    public static /* synthetic */ MobileClientVersion copy$default(MobileClientVersion mobileClientVersion, Platform platform, long l, int n, Object object) {
        if ((n & 1) != 0) {
            platform = mobileClientVersion.platform;
        }
        if ((n & 2) != 0) {
            l = mobileClientVersion.versionCode;
        }
        return mobileClientVersion.copy(platform, l);
    }

    @NotNull
    public String toString() {
        return "MobileClientVersion(platform=" + this.platform + ", versionCode=" + this.versionCode + ")";
    }

    public int hashCode() {
        int result = this.platform.hashCode();
        result = result * 31 + Long.hashCode(this.versionCode);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MobileClientVersion)) {
            return false;
        }
        MobileClientVersion mobileClientVersion = (MobileClientVersion)other;
        if (this.platform != mobileClientVersion.platform) {
            return false;
        }
        return this.versionCode == mobileClientVersion.versionCode;
    }

    public static final /* synthetic */ MobileClientVersion access$getUNKNOWN_CLIENT_VERSION$cp() {
        return UNKNOWN_CLIENT_VERSION;
    }

    public static final /* synthetic */ Regex access$getANDROID_VERSION_CODE_REGEX$cp() {
        return ANDROID_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Regex access$getIOS_VERSION_CODE_REGEX$cp() {
        return IOS_VERSION_CODE_REGEX;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ MobileClientVersion access$getUNKNOWN_ANDROID_VERSION$cp() {
        return UNKNOWN_ANDROID_VERSION;
    }

    public static final /* synthetic */ Regex access$getIOS_APP_VERSION_REGEX$cp() {
        return IOS_APP_VERSION_REGEX;
    }

    public static final /* synthetic */ MobileClientVersion access$getUNKNOWN_IOS_VERSION$cp() {
        return UNKNOWN_IOS_VERSION;
    }

    static {
        Companion $this$logger$iv = Companion;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
        ANDROID_VERSION_CODE_REGEX = new Regex("\\bJustConnect/(\\d+)\\b.*\\(Android/.*");
        IOS_VERSION_CODE_REGEX = new Regex("\\bJustConnect/(\\d+\\.\\d+(?:\\.\\d+)?) Build/\\d+ iOS/");
        IOS_APP_VERSION_REGEX = new Regex("(\\d+)\\.(\\d+)(?:\\.(\\d+))?");
    }
}

