/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.controller;

import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.mobile.controller.MobileController;
import de.justsoftware.chat.mobile.model.MobileAttachmentFilter;
import de.justsoftware.chat.mobile.model.MobileChangeList;
import de.justsoftware.chat.mobile.model.MobileChat;
import de.justsoftware.chat.mobile.model.MobileChatList;
import de.justsoftware.chat.mobile.model.MobileChatMessage;
import de.justsoftware.chat.mobile.model.MobileChatMessageList;
import de.justsoftware.chat.mobile.model.MobileChatSettings;
import de.justsoftware.chat.mobile.model.MobileClientVersion;
import de.justsoftware.chat.mobile.model.MobileMessageTypeUpdate;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.mobile.model.MobileSearchItemType;
import de.justsoftware.chat.mobile.model.MobileSearchResultList;
import de.justsoftware.chat.mobile.model.MobileSetting;
import de.justsoftware.chat.mobile.model.MobileSyncToken;
import de.justsoftware.chat.mobile.model.MobileThumbnailSize;
import de.justsoftware.chat.mobile.model.MobileUser;
import de.justsoftware.chat.mobile.model.MobileUserList;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.RestOperationsUtilsKt;
import de.justsoftware.chat.util.WebClientUtilsKt;
import java.time.Instant;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.reactive.function.client.WebClient;

@RestController
@RequestMapping(value={"/api/mobile"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 Z2\u00020\u0001:\u0001ZB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\t2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010\u0013\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J.\u0010\u0016\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010\u001b\u001a\u00020\u00182\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J \u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J*\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010&\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J \u0010(\u001a\b\u0012\u0004\u0012\u00020$0#2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010)\u001a\u00020*2\n\b\u0001\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010-\u001a\u00020\u00142\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010.\u001a\u00020/2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u00100\u001a\u00020\t2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J<\u00101\u001a\u0002022\b\b\u0001\u0010\n\u001a\u00020\u000b2\n\b\u0001\u00103\u001a\u0004\u0018\u00010\u001d2\b\b\u0001\u00104\u001a\u0002052\n\b\u0001\u00106\u001a\u0004\u0018\u0001072\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u00108\u001a\u0002092\b\b\u0001\u0010:\u001a\u0002052\b\b\u0001\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0017J\u001a\u0010>\u001a\u00020'2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010?\u001a\u00020\u001a2\b\b\u0001\u0010@\u001a\u00020A2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J.\u0010B\u001a\u00020C2\b\b\u0001\u0010D\u001a\u00020'2\b\b\u0001\u0010:\u001a\u0002052\b\b\u0001\u00104\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010E\u001a\u00020\u00142\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010F\u001a\u00020G2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010H\u001a\u00020I2\b\b\u0001\u0010J\u001a\u00020'2\b\b\u0001\u0010K\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J@\u0010L\u001a\u00020M2\b\b\u0001\u0010N\u001a\u00020'2\b\b\u0001\u0010:\u001a\u0002052\b\b\u0001\u00104\u001a\u0002052\u0010\b\u0001\u0010O\u001a\n\u0012\u0004\u0012\u00020P\u0018\u00010<2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010Q\u001a\u00020\u00182\b\b\u0001\u0010J\u001a\u00020'2\b\b\u0001\u0010K\u001a\u00020'2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010R\u001a\u00020\u00142\b\b\u0001\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010S\u001a\u00020/2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010T\u001a\u00020/2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J$\u0010U\u001a\u00020\t2\b\b\u0001\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010V\u001a\u00020W2\u0006\u0010\u0011\u001a\u00020\u0012H\u0017J\u001a\u0010X\u001a\u00020\u001a2\b\b\u0001\u0010Y\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lde/justsoftware/chat/mobile/controller/MobileController;", "", "mobileApplicationService", "Lde/justsoftware/chat/mobile/service/MobileApplicationService;", "(Lde/justsoftware/chat/mobile/service/MobileApplicationService;)V", "webClient", "Lorg/springframework/web/reactive/function/client/WebClient;", "kotlin.jvm.PlatformType", "createAttachmentMessage", "Lde/justsoftware/chat/mobile/model/MobileChatMessage;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "markChatAsRead", "", "message", "attachment", "Lorg/springframework/web/multipart/MultipartFile;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "createChat", "Lde/justsoftware/chat/mobile/model/MobileChat;", "chat", "createTextMessage", "deleteChat", "", "deleteUserImage", "Lde/justsoftware/chat/mobile/model/MobileUser;", "downloadAttachment", "messageId", "Lde/justsoftware/chat/model/ChatMessageId;", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "downloadAttachmentPreview", "Lorg/springframework/http/ResponseEntity;", "Lorg/springframework/core/io/Resource;", "downloadAttachmentThumbnail", "size", "", "downloadAttachmentVideoStream", "getChanges", "Lde/justsoftware/chat/mobile/model/MobileChangeList;", "token", "Lde/justsoftware/chat/mobile/model/MobileSyncToken;", "getChat", "getChatSettings", "Lde/justsoftware/chat/mobile/model/MobileChatSettings;", "getMessage", "getMessages", "Lde/justsoftware/chat/mobile/model/MobileChatMessageList;", "offsetMessageId", "limit", "", "attachmentFilter", "Lde/justsoftware/chat/mobile/model/MobileAttachmentFilter;", "getRecentChats", "Lde/justsoftware/chat/mobile/model/MobileChatList;", "offset", "getSettings", "", "Lde/justsoftware/chat/mobile/model/MobileSetting;", "getUnauthorizedAttachmentVideoUrl", "getUser", "userId", "Lde/justsoftware/chat/model/ProfileId;", "getUsers", "Lde/justsoftware/chat/mobile/model/MobileUserList;", "filter", "readChat", "readDate", "Ljava/time/Instant;", "registerPushToken", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "platform", "pushToken", "searchParticipants", "Lde/justsoftware/chat/mobile/model/MobileSearchResultList;", "query", "types", "Lde/justsoftware/chat/mobile/model/MobileSearchItemType;", "unregisterPushToken", "updateChat", "updateChatSettings", "chatSettings", "updateMessage", "messageTypeUpdate", "Lde/justsoftware/chat/mobile/model/MobileMessageTypeUpdate;", "updateUserImage", "image", "Companion", "chat-service"})
public class MobileController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MobileApplicationService mobileApplicationService;
    private final WebClient webClient;
    @NotNull
    public static final String MOBILE_API_BASE_PATH = "/api/mobile";

    public MobileController(@NotNull MobileApplicationService mobileApplicationService) {
        Intrinsics.checkNotNullParameter((Object)mobileApplicationService, (String)"mobileApplicationService");
        this.mobileApplicationService = mobileApplicationService;
        this.webClient = WebClient.create();
    }

    @GetMapping(value={"/chats"})
    @NotNull
    public MobileChatList getRecentChats(@RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getRecentChats(offset, limit, authContext);
    }

    @GetMapping(value={"/chats/{chatId}"})
    @NotNull
    public MobileChat getChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChat(chatId, authContext);
    }

    @PostMapping(value={"/chats"})
    @NotNull
    public MobileChat createChat(@RequestBody @NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createChat(chat, authContext);
    }

    @PutMapping(value={"/chats"})
    @NotNull
    public MobileChat updateChat(@RequestBody @NotNull MobileChat chat, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateChat(chat, authContext);
    }

    @DeleteMapping(value={"/chats/{chatId}"})
    public void deleteChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobileApplicationService.deleteChat(chatId, authContext);
    }

    @PutMapping(value={"/chats/{chatId}/read"})
    @NotNull
    public MobileChat readChat(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull Instant readDate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.readChat(chatId, readDate, authContext);
    }

    @GetMapping(value={"/chats/{chatId}/settings"})
    @NotNull
    public MobileChatSettings getChatSettings(@PathVariable(value="chatId") @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChatSettings(chatId, authContext);
    }

    @PutMapping(value={"/chats/{chatId}/settings"})
    @NotNull
    public MobileChatSettings updateChatSettings(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestBody @NotNull MobileChatSettings chatSettings2, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatSettings2, (String)"chatSettings");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateChatSettings(chatId, chatSettings2, authContext);
    }

    @GetMapping(value={"/users"})
    @NotNull
    public MobileUserList getUsers(@RequestParam(value="filter", defaultValue="") @NotNull String filter, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUsers(filter, offset, limit, authContext);
    }

    @GetMapping(value={"/users/{userId}"})
    @NotNull
    public MobileUser getUser(@PathVariable(value="userId") @NotNull ProfileId userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUser(userId, authContext);
    }

    @GetMapping(value={"/messages/{messageId}"})
    @NotNull
    public MobileChatMessage getMessage(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getMessage(messageId, authContext);
    }

    @GetMapping(value={"/chats/{chatId}/messages"})
    @NotNull
    public MobileChatMessageList getMessages(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="offsetId", required=false) @Nullable ChatMessageId offsetMessageId, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="attachmentFilter", required=false) @Nullable MobileAttachmentFilter attachmentFilter, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getMessages(chatId, offsetMessageId, limit, attachmentFilter, authContext);
    }

    @PatchMapping(value={"/messages/{messageId}"})
    @NotNull
    public MobileChatMessage updateMessage(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @RequestBody @NotNull MobileMessageTypeUpdate messageTypeUpdate, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)messageTypeUpdate, (String)"messageTypeUpdate");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateMessage(messageId, messageTypeUpdate, authContext);
    }

    @PostMapping(value={"/chats/{chatId}/messages"})
    @NotNull
    public MobileChatMessage createTextMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="markChatAsRead", defaultValue="true") boolean markChatAsRead, @RequestBody @NotNull MobileChatMessage message2, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createTextMessage(chatId, message2, markChatAsRead, authContext);
    }

    @PostMapping(value={"/chats/{chatId}/attachments"})
    @NotNull
    public MobileChatMessage createAttachmentMessage(@PathVariable(value="chatId") @NotNull ChatId chatId, @RequestParam(value="markChatAsRead", defaultValue="true") boolean markChatAsRead, @RequestPart(value="message") @NotNull MobileChatMessage message2, @RequestParam(value="attachment") @NotNull MultipartFile attachment, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.createAttachmentMessage(chatId, message2, attachment, markChatAsRead, authContext);
    }

    @GetMapping(value={"/search/participants/name"})
    @NotNull
    public MobileSearchResultList searchParticipants(@RequestParam(value="query", defaultValue="") @NotNull String query, @RequestParam(value="offset", defaultValue="0") int offset, @RequestParam(value="limit", defaultValue="20") int limit, @RequestParam(value="type", required=false) @Nullable List<? extends MobileSearchItemType> types, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.searchParticipants(query, offset, limit, types, authContext);
    }

    @GetMapping(value={"/messages/{messageId}/attachment"})
    public void downloadAttachment(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        String url = this.mobileApplicationService.downloadAttachmentUrl(messageId, authContext);
        WebClient.RequestHeadersSpec requestHeadersSpec = this.webClient.get().uri(url, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)requestHeadersSpec, (String)"webClient\n            .get()\n            .uri(url)");
        WebClientUtilsKt.exchangeToResponse((WebClient.RequestHeadersSpec)WebClientUtilsKt.addHeaders((WebClient.RequestHeadersSpec)requestHeadersSpec, (HttpHeaders)WebClientUtilsKt.getHeaders((HttpServletRequest)request)), (HttpServletResponse)response).blockLast();
    }

    @GetMapping(value={"/messages/{messageId}/attachment/thumbnail"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentThumbnail(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @RequestParam(value="size", defaultValue="MEDIUM") @NotNull String size, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.downloadAttachmentThumbnail(messageId, MobileThumbnailSize.Companion.toMobileThumbnailSize(size), authContext);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/preview"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentPreview(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.downloadAttachmentPreview(messageId, authContext);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video"})
    @NotNull
    public ResponseEntity<Resource> downloadAttachmentVideoStream(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return RestOperationsUtilsKt.redirectTo$default((String)this.mobileApplicationService.getAttachmentVideoStreamUrl(messageId, authContext), (boolean)true, null, (int)4, null);
    }

    @GetMapping(value={"/messages/{messageId}/attachment/video/url"})
    @NotNull
    public String getUnauthorizedAttachmentVideoUrl(@PathVariable(value="messageId") @NotNull ChatMessageId messageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getUnauthorizedAttachmentVideoUrl(messageId, authContext);
    }

    @PostMapping(value={"/users/image"})
    @NotNull
    public MobileUser updateUserImage(@RequestParam(value="image") @NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.updateUserImage(image, authContext);
    }

    @DeleteMapping(value={"/users/image"})
    @NotNull
    public MobileUser deleteUserImage(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.deleteUserImage(authContext);
    }

    @GetMapping(value={"/settings"})
    @NotNull
    public List<MobileSetting> getSettings() {
        return this.mobileApplicationService.getSettings();
    }

    @PostMapping(value={"/push/{platform}"})
    @NotNull
    public MobilePushToken registerPushToken(@PathVariable(value="platform") @NotNull String platform, @RequestBody @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        char[] cArray = new char[]{'\"'};
        return this.mobileApplicationService.registerPushToken(StringsKt.trim((String)pushToken, (char[])cArray), MobilePlatform.Companion.toMobilePlatform(platform), authContext);
    }

    @DeleteMapping(value={"/push/{platform}/{token}"})
    public void unregisterPushToken(@PathVariable(value="platform") @NotNull String platform, @PathVariable(value="token") @NotNull String pushToken, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)pushToken, (String)"pushToken");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        this.mobileApplicationService.unregisterPushToken(pushToken, MobilePlatform.Companion.toMobilePlatform(platform), authContext);
    }

    @GetMapping(value={"/changes"})
    @NotNull
    public MobileChangeList getChanges(@RequestParam(value="token", required=false) @Nullable MobileSyncToken token, @NotNull HttpServletRequest request, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.mobileApplicationService.getChanges(token, MobileClientVersion.Companion.toClientVersion(request), authContext);
    }
}

