/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.migration;

import de.justsoftware.chat.kafka.model.MigrationStatus;
import de.justsoftware.chat.migration.ChatMigrationStatusRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"migration.enabled"}, havingValue="true")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/chat/migration/ChatMigrationHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "chatMigrationStatusRepository", "Lde/justsoftware/chat/migration/ChatMigrationStatusRepository;", "(Lde/justsoftware/chat/migration/ChatMigrationStatusRepository;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "chat-service"})
public class ChatMigrationHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final ChatMigrationStatusRepository chatMigrationStatusRepository;

    public ChatMigrationHealthIndicator(@NotNull ChatMigrationStatusRepository chatMigrationStatusRepository) {
        Intrinsics.checkNotNullParameter((Object)chatMigrationStatusRepository, (String)"chatMigrationStatusRepository");
        super("Chat migration not finish.");
        this.chatMigrationStatusRepository = chatMigrationStatusRepository;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MigrationStatus migrationStatus = this.chatMigrationStatusRepository.getMigrationStatus();
        builder.withDetail("Chat migration status", (Object)migrationStatus);
        builder.status(migrationStatus == MigrationStatus.MIGRATION_FINISHED ? Status.UP : Status.DOWN);
    }
}

