/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.business.PermissionService;
import de.justsoftware.chat.business.XmppService;
import de.justsoftware.chat.kafka.model.MigrationStatus;
import de.justsoftware.chat.migration.ChatMigration;
import de.justsoftware.chat.model.ClusterPosition;
import de.justsoftware.chat.search.SolrIndexService;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@ConditionalOnProperty(name={"migration.enabled"}, havingValue="true")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b'\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0017\u0018\u0000 n2\u00020\u0001:\u0001nB\u0093\u0001\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0001\u0010\b\u001a\u00020\u0003\u0012\b\b\u0001\u0010\t\u001a\u00020\u0003\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017JG\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032\u001d\u00102\u001a\u0019\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020603\u00a2\u0006\u0002\b7H\u0012J{\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.2\u0006\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u00032L\u00108\u001a'\u0012#\b\u0001\u0012\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b709\"\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b7H\u0012\u00a2\u0006\u0002\u0010<J-\u0010=\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J\b\u0010?\u001a\u000206H\u0012J\u0010\u0010@\u001a\u0002062\u0006\u0010/\u001a\u00020.H\u0012J\u0010\u0010A\u001a\u0002062\u0006\u0010/\u001a\u00020.H\u0012J-\u0010B\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J-\u0010C\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J5\u0010D\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0003H\u0012J-\u0010G\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J\b\u0010H\u001a\u000206H\u0017J\u0018\u0010I\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010J\u001a\u0002062\u0006\u0010/\u001a\u00020.2\u0006\u0010-\u001a\u00020.H\u0012J\u0018\u0010K\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010L\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010M\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010N\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010O\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010P\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010Q\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010R\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J\u0018\u0010S\u001a\u0002062\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020.H\u0012J-\u0010T\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J=\u0010U\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u00032\u0006\u0010V\u001a\u00020\u0003H\u0012J-\u0010W\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J\u0010\u0010X\u001a\u0002062\u0006\u0010/\u001a\u00020.H\u0012J\u0010\u0010Y\u001a\u0002062\u0006\u0010/\u001a\u00020.H\u0012J\u0010\u0010Z\u001a\u0002062\u0006\u0010/\u001a\u00020.H\u0012J-\u0010[\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J-\u0010\\\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J-\u0010]\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J-\u0010^\u001a\u001f\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002060:\u00a2\u0006\u0002\b72\u0006\u0010>\u001a\u00020\u0003H\u0012J\u0010\u0010_\u001a\u0002062\u0006\u0010-\u001a\u00020.H\u0012J\u0014\u0010`\u001a\u000206*\u00020.2\u0006\u0010a\u001a\u00020\u0003H\u0012J\f\u0010b\u001a\u00020c*\u00020.H\u0012J\u0016\u0010d\u001a\u0004\u0018\u00010e*\u0002052\u0006\u0010>\u001a\u00020\u0003H\u0012J\f\u0010f\u001a\u00020\u001d*\u00020.H\u0012J\f\u0010g\u001a\u00020\u001d*\u00020.H\u0012J\u0014\u0010h\u001a\u000206*\u00020.2\u0006\u0010i\u001a\u00020cH\u0012J\u001e\u0010j\u001a\u000206*\u0002042\u0006\u0010k\u001a\u00020;2\b\u0010l\u001a\u0004\u0018\u00010eH\u0012J\u0014\u0010m\u001a\u000206*\u00020.2\u0006\u0010i\u001a\u00020cH\u0012R\u000e\u0010\f\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u000e\u0010\u001c\u001a\u00020\u001dX\u0092\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0019R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006o"}, d2={"Lde/justsoftware/chat/migration/ChatMigration;", "", "dbType", "", "sourceUrl", "sourceUsername", "sourcePassword", "destinationUrl", "destinationUsername", "destinationPassword", "clusterPosition", "Lde/justsoftware/chat/model/ClusterPosition;", "bootstrapServers", "solrIndexService", "Lde/justsoftware/chat/search/SolrIndexService;", "permissionService", "Lde/justsoftware/chat/business/PermissionService;", "xmppService", "Lde/justsoftware/chat/business/XmppService;", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lde/justsoftware/chat/model/ClusterPosition;Ljava/lang/String;Lde/justsoftware/chat/search/SolrIndexService;Lde/justsoftware/chat/business/PermissionService;Lde/justsoftware/chat/business/XmppService;Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "getDestinationPassword", "()Ljava/lang/String;", "getDestinationUrl", "getDestinationUsername", "isOracle", "", "getKafkaProducer", "()Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "getPermissionService", "()Lde/justsoftware/chat/business/PermissionService;", "getSolrIndexService", "()Lde/justsoftware/chat/search/SolrIndexService;", "getSourcePassword", "getSourceUrl", "getSourceUsername", "getXmppService", "()Lde/justsoftware/chat/business/XmppService;", "batchStatement", "", "sourceConnection", "Ljava/sql/Connection;", "destinationConnection", "selectStatement", "statement", "rowMapper", "Lkotlin/Function2;", "Ljava/sql/PreparedStatement;", "Ljava/sql/ResultSet;", "", "Lkotlin/ExtensionFunctionType;", "columnMappers", "", "Lkotlin/Function3;", "", "(Ljava/sql/Connection;Ljava/sql/Connection;Ljava/lang/String;Ljava/lang/String;[Lkotlin/jvm/functions/Function3;)J", "bool", "column", "cleanupOldKafkaTopics", "clearDestinationDB", "correctLastMessageId", "groupParticipantId", "int", "message", "messageTypeColumn", "messageColumn", "messageType", "migrate", "migrateChat", "migrateChatItems", "migrateChatLastMessageId", "migrateChatMessageAttachments", "migrateChatMessages", "migrateChatSettings", "migrateDatabase", "migrateMailSettings", "migrateParticipants", "migratePushTokens", "migrateReadDate", "mobilePlatform", "payload", "authorColumn", "profileParticipantId", "reindexSolr", "republishPermissions", "resyncPubSubNodes", "string", "stringUuid", "timestamp", "uuid", "waitForPreconditionsToBeMet", "executeAndClose", "sqlString", "getMigrationStatus", "Lde/justsoftware/chat/kafka/model/MigrationStatus;", "getUUID", "Ljava/util/UUID;", "hasMigratedConversationIds", "hasSchemaChangesExecuted", "setMigrationStatus", "status", "setUUID", "index", "value", "updateMigrationStatus", "Companion", "chat-service"})
public class ChatMigration {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String sourceUrl;
    @NotNull
    private final String sourceUsername;
    @NotNull
    private final String sourcePassword;
    @NotNull
    private final String destinationUrl;
    @NotNull
    private final String destinationUsername;
    @NotNull
    private final String destinationPassword;
    @NotNull
    private final ClusterPosition clusterPosition;
    @NotNull
    private final String bootstrapServers;
    @NotNull
    private final SolrIndexService solrIndexService;
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final XmppService xmppService;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ObjectMapper objectMapper;
    private final boolean isOracle;
    @NotNull
    private static final Logger LOG;
    private static final int fetchSize = 1000;
    @NotNull
    private static final String MIGRATION_ITEM_TOPIC = "just.migration.item";
    @NotNull
    private static final List<String> TOPICS_TO_CLEANUP;

    public ChatMigration(@Value(value="${migration.db.type}") @NotNull String dbType, @Value(value="${migration.source.url}") @NotNull String sourceUrl, @Value(value="${migration.source.username}") @NotNull String sourceUsername, @Value(value="${migration.source.password}") @NotNull String sourcePassword, @Value(value="${migration.destination.url}") @NotNull String destinationUrl, @Value(value="${migration.destination.username}") @NotNull String destinationUsername, @Value(value="${migration.destination.password}") @NotNull String destinationPassword, @Value(value="${service.cluster-position}") @NotNull ClusterPosition clusterPosition, @Value(value="${spring.kafka.bootstrap-servers:localhost:9092}") @NotNull String bootstrapServers, @NotNull SolrIndexService solrIndexService, @NotNull PermissionService permissionService, @NotNull XmppService xmppService, @NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Intrinsics.checkNotNullParameter((Object)sourceUsername, (String)"sourceUsername");
        Intrinsics.checkNotNullParameter((Object)sourcePassword, (String)"sourcePassword");
        Intrinsics.checkNotNullParameter((Object)destinationUrl, (String)"destinationUrl");
        Intrinsics.checkNotNullParameter((Object)destinationUsername, (String)"destinationUsername");
        Intrinsics.checkNotNullParameter((Object)destinationPassword, (String)"destinationPassword");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)solrIndexService, (String)"solrIndexService");
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)xmppService, (String)"xmppService");
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.sourceUrl = sourceUrl;
        this.sourceUsername = sourceUsername;
        this.sourcePassword = sourcePassword;
        this.destinationUrl = destinationUrl;
        this.destinationUsername = destinationUsername;
        this.destinationPassword = destinationPassword;
        this.clusterPosition = clusterPosition;
        this.bootstrapServers = bootstrapServers;
        this.solrIndexService = solrIndexService;
        this.permissionService = permissionService;
        this.xmppService = xmppService;
        this.kafkaProducer = kafkaProducer;
        this.objectMapper = objectMapper;
        this.isOracle = Intrinsics.areEqual((Object)dbType, (Object)"oracle");
    }

    @NotNull
    public String getSourceUrl() {
        return this.sourceUrl;
    }

    @NotNull
    public String getSourceUsername() {
        return this.sourceUsername;
    }

    @NotNull
    public String getSourcePassword() {
        return this.sourcePassword;
    }

    @NotNull
    public String getDestinationUrl() {
        return this.destinationUrl;
    }

    @NotNull
    public String getDestinationUsername() {
        return this.destinationUsername;
    }

    @NotNull
    public String getDestinationPassword() {
        return this.destinationPassword;
    }

    @NotNull
    public SolrIndexService getSolrIndexService() {
        return this.solrIndexService;
    }

    @NotNull
    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    @NotNull
    public XmppService getXmppService() {
        return this.xmppService;
    }

    @NotNull
    public KafkaCleaningProducer<String, String> getKafkaProducer() {
        return this.kafkaProducer;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener(value={ApplicationReadyEvent.class})
    public void migrate() {
        if (this.clusterPosition == ClusterPosition.SECONDARY) {
            LOG.info("Skip chat migration on Secondary Chat-Service");
            return;
        }
        AutoCloseable autoCloseable = DriverManager.getConnection(this.getDestinationUrl(), this.getDestinationUsername(), this.getDestinationPassword());
        Throwable throwable = null;
        try {
            Connection destinationConnection = (Connection)autoCloseable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)destinationConnection, (String)"destinationConnection");
            if (this.getMigrationStatus(destinationConnection) == MigrationStatus.MIGRATION_FINISHED) {
                LOG.info("Chat migration not required");
                return;
            }
            this.cleanupOldKafkaTopics();
            AutoCloseable autoCloseable2 = DriverManager.getConnection(this.getSourceUrl(), this.getSourceUsername(), this.getSourcePassword());
            Throwable throwable2 = null;
            try {
                Connection sourceConnection = (Connection)autoCloseable2;
                boolean bl2 = false;
                sourceConnection.setAutoCommit(false);
                Intrinsics.checkNotNullExpressionValue((Object)sourceConnection, (String)"sourceConnection");
                this.waitForPreconditionsToBeMet(sourceConnection);
                this.migrateDatabase(sourceConnection, destinationConnection);
                this.republishPermissions(destinationConnection);
                this.migrateChatItems(destinationConnection, sourceConnection);
                this.correctLastMessageId(destinationConnection);
                this.reindexSolr(destinationConnection);
                this.resyncPubSubNodes(destinationConnection);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            LOG.info("End migrate chats");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void cleanupOldKafkaTopics() {
        LOG.info("Start to cleanup old Kafka topics");
        try {
            AutoCloseable autoCloseable = (AutoCloseable)KafkaAdminClient.create((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"bootstrap.servers", (Object)this.bootstrapServers)));
            Throwable throwable = null;
            try {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                String p0;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                AdminClient adminClient = (AdminClient)autoCloseable;
                boolean bl = false;
                Object object = adminClient.listTopics().listings().get(10L, TimeUnit.SECONDS);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"adminClient\n            \u2026et(10L, TimeUnit.SECONDS)");
                Iterable iterable = (Iterable)object;
                boolean $i$f$map = false;
                void var7_11 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    TopicListing topicListing = (TopicListing)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(p0.name());
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    p0 = (String)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    void var15_22 = it;
                    Locale locale = Locale.ENGLISH;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                    String string2 = var15_22.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                    collection.add(string2);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String topic = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (!TOPICS_TO_CLEANUP.contains(topic)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List topicsToDelete = (List)destination$iv$iv;
                if (!((Collection)topicsToDelete).isEmpty()) {
                    void $this$forEach$iv;
                    LOG.info("Will delete the following old topics:");
                    $this$filter$iv = topicsToDelete;
                    Logger logger = LOG;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String p02 = (String)element$iv;
                        boolean bl5 = false;
                        logger.info(p02);
                    }
                    adminClient.deleteTopics((Collection)topicsToDelete);
                    LOG.info("Topics deleted successfully");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            LOG.error("Error when trying to delete old topics", (Throwable)e);
        }
        LOG.info("Done cleaning up old Kafka topics");
    }

    private void waitForPreconditionsToBeMet(Connection sourceConnection) {
        LOG.info("Checking schema changes in toro");
        while (!this.hasSchemaChangesExecuted(sourceConnection)) {
            LOG.info("Waiting for toro to execute Liquibase changes (5s)...");
            TimeUnit.SECONDS.sleep(5L);
        }
        LOG.info("Checking update processor states in toro");
        while (!this.hasMigratedConversationIds(sourceConnection)) {
            LOG.info("Waiting for toro to execute MIGRATE_CONVERSATION_ID update (5s)...");
            TimeUnit.SECONDS.sleep(5L);
        }
    }

    private void migrateDatabase(Connection sourceConnection, Connection destinationConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.MIGRATION_STARTED) {
            LOG.info("Chat database migration already finished. Skipping database migration...");
            return;
        }
        LOG.info("Start migrate chat database");
        this.setMigrationStatus(destinationConnection, MigrationStatus.MIGRATION_STARTED);
        this.clearDestinationDB(destinationConnection);
        this.migrateChat(sourceConnection, destinationConnection);
        this.migrateParticipants(sourceConnection, destinationConnection);
        this.migrateReadDate(sourceConnection, destinationConnection);
        this.migrateChatSettings(sourceConnection, destinationConnection);
        this.migrateChatMessages(sourceConnection, destinationConnection);
        this.migrateChatMessageAttachments(sourceConnection, destinationConnection);
        this.migrateChatLastMessageId(sourceConnection, destinationConnection);
        this.migratePushTokens(sourceConnection, destinationConnection);
        this.migrateMailSettings(sourceConnection, destinationConnection);
        this.updateMigrationStatus(destinationConnection, MigrationStatus.MIGRATE_DATABASE_FINISHED);
        LOG.info("End migrate chat database");
    }

    private void correctLastMessageId(Connection destinationConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.MIGRATE_ITEM_FINISHED) {
            LOG.info("lastMessageId of migrated chats already corrected. Skip correcting ids...");
            return;
        }
        LOG.info("Start correcting lastMessageId");
        String limit = this.isOracle ? "FETCH FIRST ROW ONLY" : "LIMIT 1";
        this.executeAndClose(destinationConnection, StringsKt.trimIndent((String)("\n            UPDATE chat c SET LAST_MESSAGE_ID = (\n                SELECT ID\n                FROM chat_message cm\n                WHERE cm.CHAT_ID = c.ID\n                    AND message_type IN ('USER_MESSAGE', 'DELETED_MESSAGE')\n                ORDER BY created_at DESC\n                " + limit + "\n            )\n            ")));
        this.executeAndClose(destinationConnection, StringsKt.trimIndent((String)("\n            UPDATE chat c SET SORT_DATE = COALESCE((\n                SELECT cm.CREATED_AT\n                FROM chat_message cm\n                WHERE cm.CHAT_ID = c.ID\n                ORDER BY created_at DESC\n                " + limit + "\n            ), CREATED_AT)\n            WHERE LAST_MESSAGE_ID IS NULL\n            ")));
        this.executeAndClose(destinationConnection, StringsKt.trimIndent((String)("\n            UPDATE chat c SET SORT_DATE = (\n                SELECT CREATED_AT\n                FROM chat_message cm\n                WHERE cm.ID = c.LAST_MESSAGE_ID\n                " + limit + "\n            )\n            WHERE LAST_MESSAGE_ID IS NOT NULL\n            ")));
        LOG.info("lastMessageId corrected");
        this.updateMigrationStatus(destinationConnection, MigrationStatus.CORRECT_LAST_MESSAGE_ID_FINISHED);
    }

    private void republishPermissions(Connection destinationConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.MIGRATE_DATABASE_FINISHED) {
            LOG.info("Permission of migrated chats already republished. Skip republish permissions...");
            return;
        }
        LOG.info("Start publish chat permissions");
        Function0 waitForRepublishFinish = this.getPermissionService().republishPermissions();
        LOG.info("Wait for chat permissions published");
        waitForRepublishFinish.invoke();
        LOG.info("Chat permissions published");
        this.updateMigrationStatus(destinationConnection, MigrationStatus.REPUBLISH_PERMISSION_FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateChatItems(Connection destinationConnection, Connection sourceConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.REPUBLISH_PERMISSION_FINISHED) {
            LOG.info("Migrate chat items for drive Attachments finished. Skip migrate items...");
            return;
        }
        LOG.info("Start migrate chat items");
        AutoCloseable autoCloseable = sourceConnection.prepareStatement("SELECT id FROM conversation");
        Throwable throwable = null;
        try {
            PreparedStatement it = (PreparedStatement)autoCloseable;
            boolean bl = false;
            it.setFetchSize(1000);
            ResultSet resultSet = it.executeQuery();
            while (resultSet.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
                UUID id = this.getUUID(resultSet, "id");
                this.getKafkaProducer().send(new ProducerRecord(MIGRATION_ITEM_TOPIC, (Object)("CONVERSATION," + id), (Object)("CHAT," + id)));
            }
            this.updateMigrationStatus(destinationConnection, MigrationStatus.MIGRATE_ITEM_FINISHED);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        LOG.info("Migrate chat items finished");
    }

    private void reindexSolr(Connection destinationConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.CORRECT_LAST_MESSAGE_ID_FINISHED) {
            LOG.info("Reindexing solr finished. Skip reindexing solr...");
            return;
        }
        LOG.info("Start reindexing solr");
        this.getSolrIndexService().reindexChatsInCommonCore();
        this.updateMigrationStatus(destinationConnection, MigrationStatus.SOLR_REINDEX_FINISHED);
        LOG.info("Reindexing solr finished");
    }

    private void resyncPubSubNodes(Connection destinationConnection) {
        if (this.getMigrationStatus(destinationConnection) != MigrationStatus.SOLR_REINDEX_FINISHED) {
            LOG.info("Resync of pub sub nodes already finished. Skip resync of pub sub nodes...");
            return;
        }
        LOG.info("Start resyncing pub sub nodes");
        this.getXmppService().clearAndSyncChatNodes();
        this.updateMigrationStatus(destinationConnection, MigrationStatus.MIGRATION_FINISHED);
        LOG.info("Resyncing pub sub nodes finished");
    }

    private void setMigrationStatus(Connection $this$setMigrationStatus, MigrationStatus status) {
        this.executeAndClose($this$setMigrationStatus, "DELETE FROM migration_status");
        this.executeAndClose($this$setMigrationStatus, "INSERT INTO migration_status (status, created_at, updated_at) VALUES('" + status.name() + "', current_timestamp, current_timestamp)");
    }

    private void updateMigrationStatus(Connection $this$updateMigrationStatus, MigrationStatus status) {
        this.executeAndClose($this$updateMigrationStatus, "UPDATE migration_status SET status = '" + status.name() + "', updated_at = current_timestamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MigrationStatus getMigrationStatus(Connection $this$getMigrationStatus) {
        MigrationStatus migrationStatus;
        Statement statement = $this$getMigrationStatus.createStatement();
        AutoCloseable autoCloseable = statement;
        Throwable throwable = null;
        try {
            MigrationStatus migrationStatus2;
            Statement it = (Statement)autoCloseable;
            boolean bl = false;
            it.execute("SELECT * FROM migration_status");
            ResultSet resultSet = statement.getResultSet();
            if (!resultSet.next()) {
                migrationStatus2 = MigrationStatus.MIGRATION_STARTED;
            } else {
                MigrationStatus migrationStatus3;
                try {
                    String string2 = resultSet.getString("status");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"resultSet.getString(\"status\")");
                    migrationStatus3 = MigrationStatus.valueOf((String)string2);
                }
                catch (IllegalArgumentException e) {
                    LOG.info("Unknown Status '" + resultSet.getString("status") + "'. Return MIGRATION_STARTED to start migration.", (Throwable)e);
                    MigrationStatus migrationStatus4 = MigrationStatus.MIGRATION_STARTED;
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    return migrationStatus4;
                }
                migrationStatus2 = migrationStatus3;
            }
            migrationStatus = migrationStatus2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return migrationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasSchemaChangesExecuted(Connection $this$hasSchemaChangesExecuted) {
        boolean bl;
        Statement statement = $this$hasSchemaChangesExecuted.createStatement();
        AutoCloseable autoCloseable = statement;
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl2 = false;
            it.execute("SELECT 1 FROM databasechangelog WHERE id = 'activate_user_groups_in_chat_by_default'");
            bl = statement.getResultSet().next();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMigratedConversationIds(Connection $this$hasMigratedConversationIds) {
        boolean bl;
        Statement statement = $this$hasMigratedConversationIds.createStatement();
        AutoCloseable autoCloseable = statement;
        Throwable throwable = null;
        try {
            Statement it = (Statement)autoCloseable;
            boolean bl2 = false;
            it.execute("SELECT DISTINCT(1) FROM juco_version_update_process WHERE process = 'MIGRATE_CONVERSATION_ID' AND status = 'COMPLETE'");
            bl = statement.getResultSet().next();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return bl;
    }

    private void clearDestinationDB(Connection destinationConnection) {
        Connection $this$clearDestinationDB_u24lambda_u2d10 = destinationConnection;
        boolean bl = false;
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_participant");
        LOG.info("Deleted table chat_participant");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE deleted_chat_participant");
        LOG.info("Deleted table deleted_chat_participant");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_read_date");
        LOG.info("Deleted table chat_read_date");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_message_attachment");
        LOG.info("Deleted table chat_message_attachment");
        if (this.isOracle) {
            this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "UPDATE chat SET last_message_id = null");
            LOG.info("updated chat");
            this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "DELETE FROM chat_message");
        } else {
            this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_message CASCADE");
        }
        LOG.info("Deleted table chat_message");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE removed_participant_profile_for_sync");
        LOG.info("Deleted table removed_participant_profile_for_sync");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_deletion");
        LOG.info("Deleted table chat_deletion");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat_settings");
        LOG.info("Deleted table chat_settings");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE mobile_push_token");
        LOG.info("Deleted table mobile_push_token");
        this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE mail_settings");
        LOG.info("Deleted table mail_settings");
        if (this.isOracle) {
            this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "DELETE FROM chat");
        } else {
            this.executeAndClose($this$clearDestinationDB_u24lambda_u2d10, "TRUNCATE TABLE chat CASCADE");
        }
        LOG.info("Deleted table chat");
    }

    private long migrateChat(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("id"), this.string("title"), this.string("type"), this.uuid("tenant_id"), this.timestamp("last_message_date"), this.timestamp("last_message_update"), this.timestamp("create_date"), this.timestamp("last_message_update")};
        return this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation", "INSERT INTO chat(id, title, type, tenant_id, sort_date, sync_date, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", function3Array);
    }

    private void migrateParticipants(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("conversation_id"), this.groupParticipantId("user_group_id"), this.timestamp("modify_date"), this.timestamp("create_date")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_user_group WHERE deleted = 'f' AND deleted_with_conversation = 'f'", "INSERT INTO chat_participant(chat_id, participant_id, permission_type, created_at, updated_at) VALUES (?, ?, 'MANAGER', ?, ?)", function3Array);
        function3Array = new Function3[]{this.uuid("conversation_id"), this.profileParticipantId("participant_id"), this.timestamp("modify_date"), this.timestamp("create_date")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_participant WHERE deleted = 'f' AND deleted_with_conversation = 'f'", "INSERT INTO chat_participant(chat_id, participant_id, permission_type, created_at, updated_at) VALUES (?, ?, 'MANAGER', ?, ?)", function3Array);
    }

    private void migrateReadDate(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("conversation_id"), this.profileParticipantId("participant_id"), this.timestamp("read_date")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_participant_read_date", "INSERT INTO chat_read_date(chat_id, profile_id, read_date) VALUES (?, ?, ?)", function3Array);
    }

    private void migrateChatSettings(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("conversation_id"), this.profileParticipantId("participant_id"), this.bool("muted"), this.timestamp("modify_date"), this.timestamp("create_date")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_settings", "INSERT INTO chat_settings(chat_id, profile_id, muted, created_at, updated_at) VALUES (?, ?, ?, ?, ?)", function3Array);
    }

    private void migrateChatMessages(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("id"), this.uuid("conversation_id"), this.message("message_type", "message"), this.messageType("message_type"), this.profileParticipantId("from_person_id"), this.timestamp("create_date"), this.timestamp("modify_date"), this.payload("message_type", "message", "from_person_id")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_message WHERE message_type != 'CONVERSATION_DELETED'", "INSERT INTO chat_message(id, chat_id, message, message_type, author, created_at, updated_at, payload) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", function3Array);
    }

    private void migrateChatMessageAttachments(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("id"), this.uuid("message_id"), this.stringUuid("document_id"), this.stringUuid("document_version_id"), this.string("content_type"), this.string("filename"), this.int("file_size"), this.timestamp("create_date"), this.timestamp("create_date"), this.int("image_height"), this.int("image_width")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT * FROM conversation_attachment", "INSERT INTO chat_message_attachment(id, message_id, document_id, document_version_id, mime_type, file_name, file_size, created_at, updated_at, height, width) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", function3Array);
    }

    private void migrateChatLastMessageId(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.uuid("last_message_id"), this.uuid("id"), this.uuid("last_message_id")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT id, last_message_id FROM conversation", "UPDATE chat SET last_message_id = ? WHERE id = ? AND EXISTS(SELECT 1 FROM chat_message WHERE id = ?)", function3Array);
    }

    private void migratePushTokens(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.string("token"), this.mobilePlatform("protocol"), this.profileParticipantId("person_id"), this.timestamp("create_at"), this.timestamp("modify_at")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT token, protocol, person_id, create_at, modify_at FROM push_target_app WHERE app_name = 'CHAT'", "INSERT INTO mobile_push_token(token, platform, profile_Id, created_at, updated_at) VALUES (?, ?, ?, ?, ?)", function3Array);
    }

    private void migrateMailSettings(Connection sourceConnection, Connection destinationConnection) {
        Function3[] function3Array = new Function3[]{this.profileParticipantId("person_id"), this.bool("notifications_enabled"), this.timestamp("create_date"), this.timestamp("modify_date")};
        this.batchStatement(sourceConnection, destinationConnection, "SELECT person_id, create_date, modify_date, notifications_enabled FROM email_notification_setting", "INSERT INTO mail_settings(profile_id, mail_delivery_enabled, created_at, updated_at) VALUES (?, ?, ?, ?)", function3Array);
    }

    private long batchStatement(Connection sourceConnection, Connection destinationConnection, String selectStatement, String statement, Function3<? super PreparedStatement, ? super ResultSet, ? super Integer, Unit> ... columnMappers) {
        return this.batchStatement(sourceConnection, destinationConnection, selectStatement, statement, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long batchStatement(Connection sourceConnection, Connection destinationConnection, String selectStatement, String statement, Function2<? super PreparedStatement, ? super ResultSet, Unit> rowMapper) {
        long insertRows = 0L;
        PreparedStatement preparedStatement = sourceConnection.prepareStatement(selectStatement);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"sourceConnection.prepareStatement(selectStatement)");
        PreparedStatement selectPreparedStatement = preparedStatement;
        selectPreparedStatement.setFetchSize(1000);
        PreparedStatement preparedStatement2 = destinationConnection.prepareStatement(statement);
        Intrinsics.checkNotNullExpressionValue((Object)preparedStatement2, (String)"destinationConnection.prepareStatement(statement)");
        PreparedStatement insertPreparedStatement = preparedStatement2;
        try {
            ResultSet resultSet = selectPreparedStatement.executeQuery();
            int batchCounter = 0;
            while (resultSet.next()) {
                Intrinsics.checkNotNullExpressionValue((Object)resultSet, (String)"resultSet");
                rowMapper.invoke((Object)insertPreparedStatement, (Object)resultSet);
                insertPreparedStatement.addBatch();
                if (++batchCounter < 1000) continue;
                int[] nArray = insertPreparedStatement.executeBatch();
                Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"insertPreparedStatement.executeBatch()");
                batchCounter = 0;
                LOG.info((insertRows += (long)ArraysKt.sum((int[])nArray)) + " rows written for " + statement);
            }
            int[] nArray = insertPreparedStatement.executeBatch();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"insertPreparedStatement.executeBatch()");
            LOG.info((insertRows += (long)ArraysKt.sum((int[])nArray)) + " rows written for " + statement);
        }
        finally {
            selectPreparedStatement.close();
            insertPreparedStatement.close();
        }
        return insertRows;
    }

    private UUID getUUID(ResultSet $this$getUUID, String column) {
        UUID uUID;
        if (this.isOracle) {
            ByteBuffer byteBuffer;
            ByteBuffer byteBuffer2;
            byte[] byArray = $this$getUUID.getBytes(column);
            if (byArray != null) {
                byte[] p0 = byArray;
                boolean bl = false;
                byteBuffer2 = ByteBuffer.wrap(p0);
            } else {
                byteBuffer2 = byteBuffer = null;
            }
            if (byteBuffer == null) {
                uUID = null;
            } else {
                long high = byteBuffer.getLong();
                long low = byteBuffer.getLong();
                uUID = new UUID(high, low);
            }
        } else {
            uUID = $this$getUUID.getObject(column, UUID.class);
        }
        return uUID;
    }

    private void setUUID(PreparedStatement $this$setUUID, int index, UUID value) {
        if (this.isOracle) {
            if (value == null) {
                $this$setUUID.setBytes(index, null);
            } else {
                ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
                bb.putLong(value.getMostSignificantBits());
                bb.putLong(value.getLeastSignificantBits());
                $this$setUUID.setBytes(index, bb.array());
            }
        } else {
            $this$setUUID.setObject(index, value);
        }
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> uuid(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> stringUuid(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> string(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> mobilePlatform(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> int(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> timestamp(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> groupParticipantId(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> profileParticipantId(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> bool(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> messageType(String column) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> message(String messageTypeColumn, String messageColumn) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    private Function3<PreparedStatement, ResultSet, Integer, Unit> payload(String messageTypeColumn, String messageColumn, String authorColumn) {
        return (Function3)new /* Unavailable Anonymous Inner Class!! */;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeAndClose(Connection $this$executeAndClose, String sqlString) {
        try (Statement statement = $this$executeAndClose.createStatement();){
            statement.execute(sqlString);
        }
    }

    public static final /* synthetic */ void access$setUUID(ChatMigration $this, PreparedStatement $receiver, int index, UUID value) {
        $this.setUUID($receiver, index, value);
    }

    public static final /* synthetic */ UUID access$getUUID(ChatMigration $this, ResultSet $receiver, String column) {
        return $this.getUUID($receiver, column);
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
        TOPICS_TO_CLEANUP = CollectionsKt.listOf((Object)"just.drive.conversationidmigration");
    }
}

