/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka.search;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatMessageCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.business.model.event.ChatsDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.kafka.search.CommonCoreSearchUpdateIndexProducer;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0011\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0012H\u0011\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0015H\u0011\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0018H\u0011\u00a2\u0006\u0002\b\u0019J\u0015\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u001bH\u0011\u00a2\u0006\u0002\b\u001cJ\u0015\u0010\u001d\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u001eH\u0011\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\fH\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lde/justsoftware/chat/kafka/search/CommonCoreSearchUpdateIndexProducer;", "", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "(Lde/justsoftware/kafka/client/KafkaCleaningProducer;Lde/justsoftware/chat/business/ChatParticipantService;)V", "fullIndex", "", "ids", "", "Lde/justsoftware/chat/model/ChatId;", "handleChatCreated", "evt", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "handleChatCreated$chat_service", "handleChatMessageCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatMessageCreatedEvent;", "handleChatMessageCreatedEvent$chat_service", "handleChatParticipantsChanged", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "handleChatParticipantsChanged$chat_service", "handleChatUpdated", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "handleChatUpdated$chat_service", "handleChatsDeleted", "Lde/justsoftware/chat/business/model/event/ChatsDeletedEvent;", "handleChatsDeleted$chat_service", "handleProfileUpdated", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "handleProfileUpdated$chat_service", "send", "id", "Companion", "chat-service"})
public class CommonCoreSearchUpdateIndexProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    public static final String TOPIC = "just.chat-service.search.common.updateIndex";

    public CommonCoreSearchUpdateIndexProducer(@NotNull KafkaCleaningProducer<String, String> kafkaProducer, @NotNull ChatParticipantService chatParticipantService) {
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        this.kafkaProducer = kafkaProducer;
        this.chatParticipantService = chatParticipantService;
    }

    public void fullIndex(@NotNull Set<ChatId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$forEach$iv = ids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
    }

    @EventListener
    public void handleChatCreated$chat_service(@NotNull ChatCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        if (evt.getChat() instanceof MultiUserChat) {
            this.send(evt.getChatId());
        }
    }

    @EventListener
    public void handleChatUpdated$chat_service(@NotNull ChatUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatId());
    }

    @EventListener
    public void handleChatsDeleted$chat_service(@NotNull ChatsDeletedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = evt.getChatIds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
    }

    @EventListener
    public void handleChatMessageCreatedEvent$chat_service(@NotNull ChatMessageCreatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatMessage().getChatId());
    }

    @EventListener
    public void handleChatParticipantsChanged$chat_service(@NotNull ChatParticipantsChangedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        this.send(evt.getChatId());
    }

    @EventListener
    public void handleProfileUpdated$chat_service(@NotNull ProfileUpdatedEvent evt) {
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        Iterable $this$forEach$iv = this.chatParticipantService.findOneOnOneChatIdsByProfileId(evt.getProfileId());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChatId p0 = (ChatId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
    }

    private void send(ChatId id) {
        this.kafkaProducer.send(new ProducerRecord(TOPIC, (Object)id.toCanonicalId(), (Object)id.toCanonicalId()));
    }
}

