/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.kafka;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.chat.business.XmppService;
import de.justsoftware.chat.business.model.xmpp.PubSubOperation;
import de.justsoftware.chat.kafka.AbstractKafkaConsumer;
import de.justsoftware.chat.kafka.KafkaConsumerContext;
import de.justsoftware.chat.kafka.KafkaObjectMapper;
import de.justsoftware.chat.kafka.PubSubOperationKafkaConsumer;
import de.justsoftware.chat.kafka.model.KafkaPubSubOperation;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00132\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0001\u0013B\u0017\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J+\u0010\f\u001a\u00020\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0010\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0004\u001a\u00020\u0002X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/chat/kafka/PubSubOperationKafkaConsumer;", "Lde/justsoftware/chat/kafka/AbstractKafkaConsumer;", "", "Lde/justsoftware/chat/kafka/model/KafkaPubSubOperation;", "bootstrapServers", "xmppService", "Lde/justsoftware/chat/business/XmppService;", "(Ljava/lang/String;Lde/justsoftware/chat/business/XmppService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "process", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "context", "Lde/justsoftware/chat/kafka/KafkaConsumerContext;", "process$chat_service", "Companion", "chat-service"})
public class PubSubOperationKafkaConsumer
extends AbstractKafkaConsumer<String, KafkaPubSubOperation> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String bootstrapServers;
    @NotNull
    private final XmppService xmppService;
    @NotNull
    private static final Logger LOG;

    public PubSubOperationKafkaConsumer(@Value(value="${spring.kafka.bootstrap-servers:localhost:9092}") @NotNull String bootstrapServers, @NotNull XmppService xmppService) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)xmppService, (String)"xmppService");
        super(Companion.createConsumer(bootstrapServers, (ObjectMapper)KafkaObjectMapper.INSTANCE), SetsKt.setOf((Object)"just.chat.pubSub.operations"));
        this.bootstrapServers = bootstrapServers;
        this.xmppService = xmppService;
    }

    @NotNull
    protected Logger getLog() {
        return LOG;
    }

    public void process$chat_service(@NotNull ConsumerRecords<String, KafkaPubSubOperation> records, @NotNull KafkaConsumerContext context) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            KafkaPubSubOperation kafkaPubSubOperation = (KafkaPubSubOperation)record.value();
            if (kafkaPubSubOperation == null) continue;
            PubSubOperation pubSubOperation = KafkaPubSubOperation.Companion.toPubSubOperation(kafkaPubSubOperation);
            Object object = record.key();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.key()");
            this.xmppService.publishStanza(pubSubOperation, (String)object);
        }
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

