/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.controller;

import de.justsoftware.chat.application.SearchApplicationService;
import de.justsoftware.chat.application.model.CommonCoreSearchResultDto;
import de.justsoftware.chat.application.model.MessageSearchResultDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.model.ChatCoreSearchSortType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.CommonCoreSearchSortType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/search"})
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0011\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\n\b\u0001\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017JX\u0010\u0013\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u00140\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u00152\b\b\u0001\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r2\b\b\u0001\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/justsoftware/chat/controller/SearchController;", "", "searchApplicationService", "Lde/justsoftware/chat/application/SearchApplicationService;", "(Lde/justsoftware/chat/application/SearchApplicationService;)V", "searchMessages", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/MessageSearchResultDto;", "query", "", "sortType", "Lde/justsoftware/chat/model/ChatCoreSearchSortType;", "page", "", "pageSize", "chatId", "Lde/justsoftware/chat/model/ChatId;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "suggestChat", "Lde/justsoftware/chat/application/model/CommonCoreSearchResultDto;", "Lde/justsoftware/chat/model/CommonCoreSearchSortType;", "onlyPersonResults", "", "chat-service"})
public class SearchController {
    @NotNull
    private final SearchApplicationService searchApplicationService;

    public SearchController(@NotNull SearchApplicationService searchApplicationService) {
        Intrinsics.checkNotNullParameter((Object)searchApplicationService, (String)"searchApplicationService");
        this.searchApplicationService = searchApplicationService;
    }

    @GetMapping(value={"/suggest"})
    @NotNull
    public Page<CommonCoreSearchResultDto<? extends Object, ? extends Object>> suggestChat(@RequestParam(value="query") @NotNull String query, @RequestParam(value="sortType", required=false, defaultValue="RELEVANCE") @NotNull CommonCoreSearchSortType sortType, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="onlyPersonResults", required=false, defaultValue="false") boolean onlyPersonResults, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchApplicationService.suggestChat(query, sortType, page, pageSize, authContext, onlyPersonResults);
    }

    @GetMapping(value={"/messages"})
    @NotNull
    public Page<MessageSearchResultDto> searchMessages(@RequestParam(value="query") @NotNull String query, @RequestParam(value="sortType", required=false, defaultValue="ACTIVITY") @NotNull ChatCoreSearchSortType sortType, @RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="pageSize", required=false, defaultValue="10") int pageSize, @RequestParam(value="chatId", required=false) @Nullable ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.searchApplicationService.searchMessages(query, chatId, sortType, page, pageSize, authContext);
    }
}

