/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.config;

import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.config.SwaggerConfiguration;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageAttachmentId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.DriveDocumentId;
import de.justsoftware.chat.model.DriveDocumentVersionId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.model.UserGroupId;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.security.OAuthFlow;
import io.swagger.v3.oas.annotations.security.OAuthFlows;
import io.swagger.v3.oas.annotations.security.OAuthScope;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springdoc.core.SpringDocUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@SecurityScheme(type=SecuritySchemeType.OAUTH2, name="oauth2", flows=@OAuthFlows(authorizationCode=@OAuthFlow(authorizationUrl="/toro/oauth/authorize", tokenUrl="/toro/oauth/token", scopes={@OAuthScope(name="api", description="Access to all your data.")})))
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017\u00a8\u0006\u0006"}, d2={"Lde/justsoftware/chat/config/SwaggerConfiguration;", "", "()V", "chatAPIDocumentation", "Lio/swagger/v3/oas/models/OpenAPI;", "Companion", "chat-service"})
public class SwaggerConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Bean
    @NotNull
    public OpenAPI chatAPIDocumentation() {
        OpenAPI openAPI = new OpenAPI().security(CollectionsKt.listOf((Object)new SecurityRequirement().addList("oauth2"))).info(new Info().title("Just Chat API"));
        Intrinsics.checkNotNullExpressionValue((Object)openAPI, (String)"OpenAPI()\n            .s\u2026).title(\"Just Chat API\"))");
        return openAPI;
    }

    static {
        Class[] classArray = new Class[]{AuthorizationContext.class};
        SpringDocUtils.getConfig().addRequestWrapperToIgnore(classArray).replaceWithClass(ChatId.class, String.class).replaceWithClass(ChatMessageId.class, String.class).replaceWithClass(ChatMessageAttachmentId.class, String.class).replaceWithClass(DriveDocumentId.class, String.class).replaceWithClass(DriveDocumentVersionId.class, String.class).replaceWithClass(TenantId.class, String.class).replaceWithClass(UserGroupId.class, String.class);
    }
}

