/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.RemovedParticipantProfileForSyncCleanupService;
import de.justsoftware.chat.mobile.service.MobileApplicationService;
import de.justsoftware.chat.persistence.RemovedParticipantProfileForSyncRepository;
import java.time.Clock;
import java.time.Instant;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lde/justsoftware/chat/business/RemovedParticipantProfileForSyncCleanupService;", "", "removedParticipantProfileRepository", "Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/persistence/RemovedParticipantProfileForSyncRepository;Ljava/time/Clock;)V", "cleanObsoleteEntries", "", "Companion", "chat-service"})
public class RemovedParticipantProfileForSyncCleanupService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Logger LOG;

    public RemovedParticipantProfileForSyncCleanupService(@NotNull RemovedParticipantProfileForSyncRepository removedParticipantProfileRepository, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)removedParticipantProfileRepository, (String)"removedParticipantProfileRepository");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.removedParticipantProfileRepository = removedParticipantProfileRepository;
        this.clock = clock;
    }

    @Scheduled(cron="0 10 20 * * *")
    @Transactional
    public void cleanObsoleteEntries() {
        Instant createdAtBefore = this.clock.instant().minus(MobileApplicationService.Companion.getCHAT_CHANGES_MAX_AGE());
        LOG.info("Start deleting removed participant profile entries from before " + createdAtBefore);
        Intrinsics.checkNotNullExpressionValue((Object)createdAtBefore, (String)"createdAtBefore");
        long deleted = this.removedParticipantProfileRepository.deleteByCreatedAtLessThan(createdAtBefore);
        LOG.info("Deleted " + deleted + " removed participant profile entries");
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
    }
}

