/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatParticipant;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.event.ChatMarkedForDeletionEvent;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.notificationclient.NotificationProducer;
import de.justsoftware.notificationclient.model.Notification;
import de.justsoftware.notificationclient.model.NotificationBuilder;
import de.justsoftware.notificationclient.model.NotificationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ:\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0019H\u0012J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J:\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0019H\u0012JV\u0010 \u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u00192\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\n0\u0019H\u0012R\u000e\u0010\t\u001a\u00020\nX\u0092D\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/chat/business/NotificationService;", "", "resourceBundle", "Lorg/springframework/context/support/ResourceBundleMessageSource;", "notificationProducer", "Lde/justsoftware/notificationclient/NotificationProducer;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "(Lorg/springframework/context/support/ResourceBundleMessageSource;Lde/justsoftware/notificationclient/NotificationProducer;Lde/justsoftware/chat/business/ProfileService;)V", "appId", "", "locales", "", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "multiUserChatDeleted", "", "chat", "Lde/justsoftware/chat/business/model/MultiUserChat;", "author", "Lde/justsoftware/chat/business/model/Profile;", "receiverIds", "", "Lde/justsoftware/chat/model/ParticipantId;", "localeNotificationTitle", "", "onChatMarkedForDeletion", "event", "Lde/justsoftware/chat/business/model/event/ChatMarkedForDeletionEvent;", "oneOnOneChatDeleted", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "sendNotifications", "title", "notificationType", "Lde/justsoftware/notificationclient/model/NotificationType;", "localText", "localTitle", "chat-service"})
public class NotificationService {
    @NotNull
    private final ResourceBundleMessageSource resourceBundle;
    @NotNull
    private final NotificationProducer notificationProducer;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final String appId;
    @NotNull
    private final List<Locale> locales;

    public NotificationService(@NotNull ResourceBundleMessageSource resourceBundle, @NotNull NotificationProducer notificationProducer, @NotNull ProfileService profileService) {
        Intrinsics.checkNotNullParameter((Object)resourceBundle, (String)"resourceBundle");
        Intrinsics.checkNotNullParameter((Object)notificationProducer, (String)"notificationProducer");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        this.resourceBundle = resourceBundle;
        this.notificationProducer = notificationProducer;
        this.profileService = profileService;
        this.appId = "chat";
        Object[] objectArray = new Locale[]{Locale.GERMAN, Locale.ENGLISH};
        this.locales = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @EventListener
    public void onChatMarkedForDeletion(@NotNull ChatMarkedForDeletionEvent event) {
        void $this$filterTo$iv$iv;
        void $this$filterToSet$iv;
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Profile author = this.profileService.getById(event.getAuthorId());
        Iterable $this$map$iv = event.getParticipants();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatParticipant chatParticipant = (ChatParticipant)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getParticipantId());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filterToSet = false;
        $this$mapTo$iv$iv = $this$filterToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterToSet$iv));
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ParticipantId it = (ParticipantId)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)event.getAuthorId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set participants = (Set)destination$iv$iv;
        Iterable $this$associateWith$iv = this.locales;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void locale;
            Locale bl = (Locale)element$iv$iv;
            Object t = element$iv$iv;
            object = result$iv;
            boolean bl2 = false;
            boolean $i$f$emptyArray = false;
            String string2 = this.resourceBundle.getMessage("chat.notificationService.chatDeletedTitle", new Object[0], (Locale)locale);
            object.put(t, string2);
        }
        Map localeNotificationTitle = result$iv;
        Chat chat = event.getChat();
        if (chat instanceof MultiUserChat) {
            this.multiUserChatDeleted((MultiUserChat)event.getChat(), author, participants, localeNotificationTitle);
        } else if (chat instanceof OneOnOneChat) {
            this.oneOnOneChatDeleted(event.getChat().getTenantId(), author, participants, localeNotificationTitle);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void oneOnOneChatDeleted(TenantId tenantId, Profile author, Set<? extends ParticipantId> receiverIds, Map<Locale, String> localeNotificationTitle) {
        Iterable $this$associateWith$iv = this.locales;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void locale;
            Locale locale2 = (Locale)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{author.getFullName(), author.getFullName()};
            String string2 = this.resourceBundle.getMessage("chat.notificationService.chatDeletedText", objectArray, (Locale)locale);
            map.put(t, string2);
        }
        Map localText = result$iv;
        this.sendNotifications(tenantId, author.getFullName(), receiverIds, NotificationType.CONVERSATION_DELETED, localText, localeNotificationTitle);
    }

    /*
     * WARNING - void declaration
     */
    private void multiUserChatDeleted(MultiUserChat chat, Profile author, Set<? extends ParticipantId> receiverIds, Map<Locale, String> localeNotificationTitle) {
        Iterable $this$associateWith$iv = this.locales;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Locale locale = (Locale)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{chat.getTitle(), author.getFullName()};
            String string2 = this.resourceBundle.getMessage("chat.notificationService.chatDeletedText", objectArray, (Locale)it);
            map.put(t, string2);
        }
        Map localText = result$iv;
        this.sendNotifications(chat.getTenantId(), chat.getTitle(), receiverIds, NotificationType.CONVERSATION_DELETED, localText, localeNotificationTitle);
    }

    /*
     * WARNING - void declaration
     */
    private void sendNotifications(TenantId tenantId, String title, Set<? extends ParticipantId> receiverIds, NotificationType notificationType, Map<Locale, String> localText, Map<Locale, String> localTitle) {
        void $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        if (receiverIds.isEmpty()) {
            return;
        }
        UUID uUID = tenantId.getValue();
        Locale locale = Locale.GERMAN;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"GERMAN");
        Iterable iterable = receiverIds;
        NotificationBuilder notificationBuilder = Notification.builder((UUID)uUID, (String)this.appId, (String)title, (String)((String)MapsKt.getValue(localText, (Object)locale)), (NotificationType)notificationType).withLocalizedTitle(localTitle).withLocalizedText(localText);
        boolean $i$f$mapToSet = false;
        void var9_11 = $this$mapToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        iterable = notificationBuilder.withReceivers((Set)destination$iv$iv).withPayload(this.appId).build();
        NotificationProducer notificationProducer = this.notificationProducer;
        Iterable p0 = iterable;
        boolean bl = false;
        notificationProducer.dispatchNotification((Notification)p0);
    }
}

