/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.CommonCoreSearchService;
import de.justsoftware.chat.model.CommonCoreSearchFields;
import de.justsoftware.chat.model.CommonCoreSearchModelType;
import de.justsoftware.chat.model.CommonCoreSearchResult;
import de.justsoftware.chat.model.CommonCoreSearchSortType;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.PagingUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JV\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0019\b\u0002\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017H\u0012\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0012J\\\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0019\b\u0002\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0015\u00a2\u0006\u0002\b\u0017H\u0012\u00a2\u0006\u0002\u0010\u001fJA\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J0\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/chat/business/CommonCoreSearchService;", "", "commonCoreFollowerSolrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "(Lorg/apache/solr/client/solrj/SolrClient;Lde/justsoftware/chat/authorization/AuthorizationService;)V", "buildSolrQuery", "Lorg/apache/solr/client/solrj/SolrQuery;", "query", "", "types", "", "Lde/justsoftware/chat/model/CommonCoreSearchModelType;", "sortBy", "Lde/justsoftware/chat/model/CommonCoreSearchSortType;", "searchBy", "Lde/justsoftware/chat/model/ProfileId;", "pageable", "Lorg/springframework/data/domain/Pageable;", "configure", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/apache/solr/client/solrj/SolrQuery;", "send", "Lorg/apache/solr/client/solrj/response/QueryResponse;", "solrQuery", "sendSolrQuery", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/model/CommonCoreSearchResult;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lorg/springframework/data/domain/Pageable;Lkotlin/jvm/functions/Function1;)Lorg/springframework/data/domain/Page;", "suggestChat", "offset", "Lde/justsoftware/chat/model/Offset;", "(Ljava/lang/String;[Lde/justsoftware/chat/model/CommonCoreSearchModelType;Lde/justsoftware/chat/model/CommonCoreSearchSortType;Lde/justsoftware/chat/model/ProfileId;Lde/justsoftware/chat/model/Offset;)Lorg/springframework/data/domain/Page;", "suggestUser", "Companion", "chat-service"})
public class CommonCoreSearchService {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SolrClient commonCoreFollowerSolrClient;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String QUERY_PERSON_IDS_PARAM_NAME = "jucoPersonIds";
    @NotNull
    private static final String QUERY_ROLES_PARAM_NAME = "jucoRoles";
    @NotNull
    private static final String ROLE_VISIBILITY_FILTER_QUERY = "_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\"";
    @NotNull
    private static final String PERSON_VISIBILITY_FILTER_QUERY = "_query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\"";
    @NotNull
    private static final String VISIBILITY_FILTER_QUERY = "(_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\" OR _query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\")";
    @NotNull
    private static final String REQUESTED_FIELDS;

    public CommonCoreSearchService(@Qualifier(value="commonCoreFollowerSolrClient") @NotNull SolrClient commonCoreFollowerSolrClient, @NotNull AuthorizationService authorizationService) {
        Intrinsics.checkNotNullParameter((Object)commonCoreFollowerSolrClient, (String)"commonCoreFollowerSolrClient");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        this.commonCoreFollowerSolrClient = commonCoreFollowerSolrClient;
        this.authorizationService = authorizationService;
    }

    @NotNull
    public Page<CommonCoreSearchResult> suggestChat(@NotNull String query, @NotNull CommonCoreSearchModelType[] types, @NotNull CommonCoreSearchSortType sortBy, @NotNull ProfileId searchBy, @NotNull Offset offset) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return types.length == 0 ? PagingUtilsKt.emptyPage((Pageable)CommonCoreSearchSortType.Companion.toPageable(offset, sortBy)) : this.sendSolrQuery(query, types, sortBy, searchBy, CommonCoreSearchSortType.Companion.toPageable(offset, sortBy), (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public Page<CommonCoreSearchResult> suggestUser(@NotNull String query, @NotNull ProfileId searchBy, @NotNull Offset offset, @NotNull CommonCoreSearchSortType sortBy) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)searchBy, (String)"searchBy");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)sortBy, (String)"sortBy");
        CommonCoreSearchModelType[] commonCoreSearchModelTypeArray = new CommonCoreSearchModelType[]{CommonCoreSearchModelType.PERSON};
        return CommonCoreSearchService.sendSolrQuery$default((CommonCoreSearchService)this, (String)query, (CommonCoreSearchModelType[])commonCoreSearchModelTypeArray, (CommonCoreSearchSortType)sortBy, (ProfileId)searchBy, (Pageable)CommonCoreSearchSortType.Companion.toPageable(offset, sortBy), null, (int)32, null);
    }

    public static /* synthetic */ Page suggestUser$default(CommonCoreSearchService commonCoreSearchService, String string2, ProfileId profileId, Offset offset, CommonCoreSearchSortType commonCoreSearchSortType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: suggestUser");
        }
        if ((n & 8) != 0) {
            commonCoreSearchSortType = CommonCoreSearchSortType.ALPHABETICAL;
        }
        return commonCoreSearchService.suggestUser(string2, profileId, offset, commonCoreSearchSortType);
    }

    private Page<CommonCoreSearchResult> sendSolrQuery(String query, CommonCoreSearchModelType[] types, CommonCoreSearchSortType sortBy, ProfileId searchBy, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        return Companion.access$toSearchResultsPage((Companion)Companion, (QueryResponse)this.send(this.buildSolrQuery(query, types, sortBy, searchBy, pageable, configure)), (Pageable)pageable);
    }

    static /* synthetic */ Page sendSolrQuery$default(CommonCoreSearchService commonCoreSearchService, String string2, CommonCoreSearchModelType[] commonCoreSearchModelTypeArray, CommonCoreSearchSortType commonCoreSearchSortType, ProfileId profileId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendSolrQuery");
        }
        if ((n & 0x20) != 0) {
            function1 = (Function1)sendSolrQuery.1.INSTANCE;
        }
        return commonCoreSearchService.sendSolrQuery(string2, commonCoreSearchModelTypeArray, commonCoreSearchSortType, profileId, pageable, function1);
    }

    private SolrQuery buildSolrQuery(String query, CommonCoreSearchModelType[] types, CommonCoreSearchSortType sortBy, ProfileId searchBy, Pageable pageable, Function1<? super SolrQuery, Unit> configure) {
        SolrQuery solrQuery;
        SolrQuery $this$buildSolrQuery_u24lambda_u2d0 = solrQuery = new SolrQuery();
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)query)) {
            $this$buildSolrQuery_u24lambda_u2d0.setQuery(Companion.access$toEscapedQuery((Companion)Companion, (String)query));
        }
        $this$buildSolrQuery_u24lambda_u2d0.setHighlight(true);
        String[] stringArray = new String[]{sortBy.getSolrSortValue()};
        $this$buildSolrQuery_u24lambda_u2d0.add("sort", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getOffset())};
        $this$buildSolrQuery_u24lambda_u2d0.set("start", stringArray);
        stringArray = new String[]{String.valueOf(pageable.getPageSize())};
        $this$buildSolrQuery_u24lambda_u2d0.set("rows", stringArray);
        stringArray = new String[]{REQUESTED_FIELDS};
        $this$buildSolrQuery_u24lambda_u2d0.set("fl", stringArray);
        stringArray = new String[]{ArraysKt.joinToString$default((Object[])types, (CharSequence)" OR ", null, null, (int)0, null, (Function1)((Function1)buildSolrQuery.2.1.INSTANCE), (int)30, null)};
        $this$buildSolrQuery_u24lambda_u2d0.addFilterQuery(stringArray);
        String searchRoles = CollectionsKt.joinToString$default((Iterable)this.authorizationService.searchRolesBy(searchBy), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String[] stringArray2 = new String[]{"(_query_:\"{!edismax q.op=OR qf=visible_for_roles mm=1 v=$jucoRoles}\" OR _query_:\"{!edismax q.op=OR qf=visible_for_persons mm=1 v=$jucoPersonIds}\")"};
        $this$buildSolrQuery_u24lambda_u2d0.addFilterQuery(stringArray2);
        stringArray2 = new String[]{searchRoles};
        $this$buildSolrQuery_u24lambda_u2d0.add("jucoRoles", stringArray2);
        stringArray2 = new String[]{String.valueOf(searchBy.getValue())};
        $this$buildSolrQuery_u24lambda_u2d0.add("jucoPersonIds", stringArray2);
        $this$buildSolrQuery_u24lambda_u2d0.setRequestHandler("suggest");
        configure.invoke((Object)$this$buildSolrQuery_u24lambda_u2d0);
        return solrQuery;
    }

    static /* synthetic */ SolrQuery buildSolrQuery$default(CommonCoreSearchService commonCoreSearchService, String string2, CommonCoreSearchModelType[] commonCoreSearchModelTypeArray, CommonCoreSearchSortType commonCoreSearchSortType, ProfileId profileId, Pageable pageable, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: buildSolrQuery");
        }
        if ((n & 0x20) != 0) {
            function1 = (Function1)buildSolrQuery.1.INSTANCE;
        }
        return commonCoreSearchService.buildSolrQuery(string2, commonCoreSearchModelTypeArray, commonCoreSearchSortType, profileId, pageable, function1);
    }

    private QueryResponse send(SolrQuery solrQuery) {
        QueryResponse queryResponse;
        try {
            QueryResponse queryResponse2 = this.commonCoreFollowerSolrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            Intrinsics.checkNotNullExpressionValue((Object)queryResponse2, (String)"{\n            commonCore\u2026y, METHOD.POST)\n        }");
            queryResponse = queryResponse2;
        }
        catch (Exception e) {
            LOG.error("Error occurred while executing query " + solrQuery, (Throwable)e);
            throw e;
        }
        return queryResponse;
    }

    static {
        Companion $this$logger$iv = Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(Companion.class).isCompanion() ? Companion.class.getEnclosingClass() : Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n        if (T\u2026 else T::class.java\n    )");
        LOG = logger;
        CommonCoreSearchFields $this$REQUESTED_FIELDS_u24lambda_u2d1 = CommonCoreSearchFields.INSTANCE;
        boolean bl = false;
        REQUESTED_FIELDS = "id, name, type, chat_type, modify_date";
    }
}

