/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.persistence.ChatSettingsRepository;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatSettings;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u001e\u0010\u0012\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u00130\u0013H\u0016J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J*\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0016J*\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000bH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lde/justsoftware/chat/business/ChatSettingsService;", "", "chatSettingsRepository", "Lde/justsoftware/chat/persistence/ChatSettingsRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "(Lde/justsoftware/chat/persistence/ChatSettingsRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/util/TransactionUtils;)V", "findByChatIdAndProfileId", "Ljava/util/Optional;", "Lde/justsoftware/chat/business/model/ChatSettings;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "findProfilesWithNonMutedChats", "", "profileIdsWithUnreadChatCounts", "", "", "findUpdatedAndSpecificSettings", "", "chatIds", "updatedSince", "Ljava/time/Instant;", "getSettings", "getSettingsForChat", "profileIds", "muteChat", "isMuted", "", "save", "chatSettings", "chat-service"})
public class ChatSettingsService {
    @NotNull
    private final ChatSettingsRepository chatSettingsRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final TransactionUtils transactionUtils;

    public ChatSettingsService(@NotNull ChatSettingsRepository chatSettingsRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull TransactionUtils transactionUtils) {
        Intrinsics.checkNotNullParameter((Object)chatSettingsRepository, (String)"chatSettingsRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        this.chatSettingsRepository = chatSettingsRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.transactionUtils = transactionUtils;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ChatId, ChatSettings> getSettings(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds2) {
        void $this$associateTo$iv$iv;
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Iterable iterable = chatIds2;
        String string2 = profileId.toCanonicalId();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByProfileIdAndChatIds(string2, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            UUID chatId = (UUID)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)new ChatId(chatId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, ChatSettings> getSettingsForChat(@NotNull ChatId chatId, @NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        UUID uUID = chatId.getValue();
        ChatSettingsRepository chatSettingsRepository = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        collection = (List)destination$iv$iv;
        Iterable $this$associate$iv = chatSettingsRepository.findByChatIdAndProfileIds(uUID, (Iterable)collection).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            DbChatSettings dbChatSettings = (DbChatSettings)entry.getValue();
            entry = TuplesKt.to((Object)ProfileId.Companion.fromCanonicalId(profileId), (Object)DbChatSettings.Companion.toChatSettings(dbChatSettings));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    @Transactional
    @NotNull
    public ChatSettings muteChat(@NotNull ChatId chatId, @NotNull ProfileId profileId, boolean isMuted) {
        ChatSettings chatSettings2;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ChatSettings currentSettings = this.findByChatIdAndProfileId(chatId, profileId).orElseGet(() -> ChatSettingsService.muteChat$lambda-3(chatId, profileId));
        if (currentSettings.getMuted() == isMuted) {
            Intrinsics.checkNotNullExpressionValue((Object)currentSettings, (String)"currentSettings");
            chatSettings2 = currentSettings;
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)currentSettings, (String)"currentSettings");
            chatSettings2 = this.save(ChatSettings.copy$default((ChatSettings)currentSettings, null, null, (boolean)isMuted, null, (int)11, null));
        }
        return chatSettings2;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public Set<ProfileId> findProfilesWithNonMutedChats(@NotNull Map<ProfileId, ? extends Map<ChatId, Long>> profileIdsWithUnreadChatCounts) {
        Intrinsics.checkNotNullParameter(profileIdsWithUnreadChatCounts, (String)"profileIdsWithUnreadChatCounts");
        var3_2 = profileIdsWithUnreadChatCounts.keySet();
        var30_3 = this.chatSettingsRepository;
        $i$f$map = false;
        var5_5 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var10_13 = (ProfileId)item$iv$iv;
            var31_16 /* !! */  = destination$iv$iv;
            $i$a$-map-ChatSettingsService$findProfilesWithNonMutedChats$savedSettings$1 = false;
            var31_16 /* !! */ .add(p0.toCanonicalId());
        }
        $this$map$iv = profileIdsWithUnreadChatCounts.values();
        var31_16 /* !! */  = (List)destination$iv$iv;
        $i$f$flatMapToSet = false;
        $this$mapTo$iv$iv = $this$flatMapToSet$iv;
        destination$iv$iv = new LinkedHashSet<E>(CollectionUtilsKt.getDefaultSize((Iterable)$this$flatMapToSet$iv));
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (Map)element$iv$iv;
            $i$a$-flatMapToSet-ChatSettingsService$findProfilesWithNonMutedChats$savedSettings$2 = false;
            list$iv$iv = p0.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        var32_17 = (Set)destination$iv$iv;
        $this$flatMapToSet$iv = (Iterable)var32_17;
        $i$f$mapToSet = false;
        $this$flatMapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet<E>(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ChatId)item$iv$iv;
            var32_17 = destination$iv$iv;
            $i$a$-mapToSet-ChatSettingsService$findProfilesWithNonMutedChats$savedSettings$3 = false;
            var32_17.add(p0.getValue());
        }
        var32_17 = (Set)destination$iv$iv;
        $this$groupBy$iv = var30_3.findByProfileIdsAndChatIds(var31_16 /* !! */ , (Iterable)var32_17);
        $i$f$groupBy = false;
        $this$mapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        var8_9 = $this$groupByTo$iv$iv.iterator();
        while (var8_9.hasNext()) {
            element$iv$iv = var8_9.next();
            it = (DbChatSettings)element$iv$iv;
            $i$a$-groupBy-ChatSettingsService$findProfilesWithNonMutedChats$savedSettings$4 = false;
            key$iv$iv /* !! */  = ProfileId.Companion.fromCanonicalId(it.getProfileId());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv /* !! */ );
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv /* !! */ , answer$iv$iv$iv);
                v0 /* !! */  = answer$iv$iv$iv;
            } else {
                v0 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v0 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        savedSettings = destination$iv$iv;
        $this$mapValues$iv = profileIdsWithUnreadChatCounts;
        $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (E element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            block13: {
                block14: {
                    key$iv$iv /* !! */  = (Map.Entry)element$iv$iv$iv;
                    var13_19 = destination$iv$iv;
                    $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
                    var15_21 = (Map.Entry)element$iv$iv$iv;
                    var31_16 /* !! */  = it$iv$iv.getKey();
                    var30_3 = var13_19;
                    $i$a$-mapValues-ChatSettingsService$findProfilesWithNonMutedChats$1 = false;
                    profileId = (ProfileId)var15_21.getKey();
                    chatIdsWithUnreadCounts = (Map)var15_21.getValue();
                    $this$all$iv = chatIdsWithUnreadCounts.keySet();
                    $i$f$all = false;
                    if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) break block14;
                    v1 = true;
                    break block13;
                }
                for (T element$iv : $this$all$iv) {
                    block12: {
                        chatId = (ChatId)element$iv;
                        $i$a$-all-ChatSettingsService$findProfilesWithNonMutedChats$1$1 = false;
                        v2 = (List)savedSettings.get(profileId);
                        if (v2 == null) ** GOTO lbl-1000
                        var25_34 = v2;
                        for (T var27_36 : var25_34) {
                            setting = (DbChatSettings)var27_36;
                            $i$a$-find-ChatSettingsService$findProfilesWithNonMutedChats$1$1$1 = false;
                            if (!Intrinsics.areEqual((Object)setting.getChatId(), (Object)chatId.getValue())) continue;
                            v3 = var27_36;
                            break block12;
                        }
                        v3 = null;
                    }
                    if ((v2 = (DbChatSettings)v3) != null) {
                        v4 = v2.getMuted();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = false;
                    }
                    if (v4) continue;
                    v1 = false;
                    break block13;
                }
                v1 = true;
            }
            var32_17 = v1;
            var30_3.put(var31_16 /* !! */ , var32_17);
        }
        $this$filterValues$iv = destination$iv$iv;
        $i$f$filterValues = false;
        result$iv = new LinkedHashMap<K, V>();
        for (Map.Entry<K, V> entry$iv : $this$filterValues$iv.entrySet()) {
            hasOnlyMutedChats = (Boolean)entry$iv.getValue();
            $i$a$-filterValues-ChatSettingsService$findProfilesWithNonMutedChats$2 = false;
            if (!(hasOnlyMutedChats == false)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).keySet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<ChatSettings> findUpdatedAndSpecificSettings(@NotNull ProfileId profileId, @NotNull Set<ChatId> chatIds2, @NotNull Instant updatedSince) {
        DbChatSettings p0;
        Collection<UUID> collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        Intrinsics.checkNotNullParameter((Object)updatedSince, (String)"updatedSince");
        if (!(chatIds2.size() <= 1000)) {
            boolean $i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22 = false;
            String $i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22 = "Got " + chatIds2.size() + " chat IDs, but only 1000 are allowed in a WHERE-IN-clause";
            throw new IllegalArgumentException($i$a$-require-ChatSettingsService$findUpdatedAndSpecificSettings$22.toString());
        }
        Iterable iterable = chatIds2;
        Instant instant = updatedSince;
        String string2 = profileId.toCanonicalId();
        Object object = this.chatSettingsRepository;
        boolean $i$f$map = false;
        void var6_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatId chatId = (ChatId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = object.findByProfileIdAndUpdatedAtGreaterThanOrChatIdIn(string2, instant, (Iterable)collection);
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (DbChatSettings)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(DbChatSettings.Companion.toChatSettings((DbChatSettings)it));
        }
        return (List)destination$iv$iv;
    }

    private ChatSettings save(ChatSettings chatSettings2) {
        ChatSettings chatSettings3;
        Object object = this.chatSettingsRepository.save((Object)DbChatSettings.Companion.toDbChatSettings(chatSettings2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatSettingsRepository\n \u2026tings.toDbChatSettings())");
        ChatSettings savedChatSettings = chatSettings3 = DbChatSettings.Companion.toChatSettings((DbChatSettings)object);
        boolean bl = false;
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return chatSettings3;
    }

    private Optional<ChatSettings> findByChatIdAndProfileId(ChatId chatId, ProfileId profileId) {
        Optional<ChatSettings> optional = this.chatSettingsRepository.findById((Object)new DbChatProfileId(chatId, profileId)).map(ChatSettingsService::findByChatIdAndProfileId$lambda-16);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"chatSettingsRepository\n \u2026p { it.toChatSettings() }");
        return optional;
    }

    private static final ChatSettings muteChat$lambda-3(ChatId $chatId, ProfileId $profileId) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        return new ChatSettings($chatId, $profileId, false, null, 12, null);
    }

    private static final ChatSettings findByChatIdAndProfileId$lambda-16(DbChatSettings it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatSettings.Companion.toChatSettings(it);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatSettingsService $this) {
        return $this.applicationEventPublisher;
    }
}

