/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatMessageService$validatedMessageForDelete$;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.DriveService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatMessageAttachment;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.SystemMessage;
import de.justsoftware.chat.business.model.UserMessage;
import de.justsoftware.chat.business.model.event.ChatCreatedEvent;
import de.justsoftware.chat.business.model.event.ChatParticipantsChangedEvent;
import de.justsoftware.chat.business.model.event.ChatUpdatedEvent;
import de.justsoftware.chat.exception.ChatMessageAlreadyExistsException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ChatMessagePayload;
import de.justsoftware.chat.model.LimitOffset;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.ParticipantId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.UserGroupId;
import de.justsoftware.chat.persistence.ChatMessageRepository;
import de.justsoftware.chat.persistence.ChatMessageSpecifications;
import de.justsoftware.chat.persistence.ChatRepository;
import de.justsoftware.chat.persistence.model.DbChatMessage;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import de.justsoftware.chat.util.RepositoryUtilKt;
import de.justsoftware.chat.util.TransactionUtils;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00da\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 R2\u00020\u0001:\u0001RB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0017J\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00182\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0012J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0012J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 H\u0016J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"2\u0006\u0010#\u001a\u00020\u001cH\u0017J\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00120%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0'H\u0017J$\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001e0'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u001cH\u0017J@\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0012002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u0002062\n\b\u0002\u00107\u001a\u0004\u0018\u00010-2\n\b\u0002\u00108\u001a\u0004\u0018\u000109H\u0017J.\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0012002\f\u0010;\u001a\b\u0012\u0004\u0012\u0002020<2\b\u0010=\u001a\u0004\u0018\u00010-2\u0006\u00103\u001a\u000204H\u0016J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0017J\u0010\u0010B\u001a\u00020?2\u0006\u0010C\u001a\u00020DH\u0017J\u0010\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020GH\u0017J\u0010\u0010H\u001a\u00020?2\u0006\u0010C\u001a\u00020DH\u0012J\u0010\u0010I\u001a\u00020?2\u0006\u0010C\u001a\u00020DH\u0012J \u0010J\u001a\n K*\u0004\u0018\u00010\u00180\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\f\u0010L\u001a\u00020?*\u00020DH\u0012J+\u0010M\u001a\u0002HN\"\b\b\u0000\u0010N*\u00020\u0012*\u0002HN2\u000e\b\u0002\u0010O\u001a\b\u0012\u0004\u0012\u00020P0\u0015H\u0012\u00a2\u0006\u0002\u0010QR\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lde/justsoftware/chat/business/ChatMessageService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageRepository", "Lde/justsoftware/chat/persistence/ChatMessageRepository;", "chatRepository", "Lde/justsoftware/chat/persistence/ChatRepository;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/chat/business/DriveService;", "transactionUtils", "Lde/justsoftware/chat/util/TransactionUtils;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/persistence/ChatMessageRepository;Lde/justsoftware/chat/persistence/ChatRepository;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/chat/business/DriveService;Lde/justsoftware/chat/util/TransactionUtils;Ljava/time/Clock;)V", "create", "Lde/justsoftware/chat/business/model/ChatMessage;", "chatMessage", "files", "", "Lorg/springframework/web/multipart/MultipartFile;", "createWithAttachments", "Lde/justsoftware/chat/business/model/UserMessage;", "createWithoutAttachments", "delete", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "findAllUserMessages", "Lkotlin/sequences/Sequence;", "findById", "Ljava/util/Optional;", "id", "findByIds", "", "ids", "", "findUpdatedAuthors", "participantIds", "", "Lde/justsoftware/chat/model/ParticipantId;", "since", "Ljava/time/Instant;", "getById", "getMessages", "Lorg/springframework/data/domain/Page;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "offsetTimestamp", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "getRecentMessages", "chatIds", "", "updatedSince", "onChatCreatedEvent", "", "chatCreatedEvent", "Lde/justsoftware/chat/business/model/event/ChatCreatedEvent;", "onChatParticipantsChangedEvent", "chatParticipantsChangedEvent", "Lde/justsoftware/chat/business/model/event/ChatParticipantsChangedEvent;", "onChatUpdatedEvent", "chatUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ChatUpdatedEvent;", "sendSystemMessageForAddedParticipants", "sendSystemMessageForRemovedParticipants", "validatedMessageForDelete", "kotlin.jvm.PlatformType", "handleDeletedParticipants", "validatedForCreate", "T", "attachments", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "(Lde/justsoftware/chat/business/model/ChatMessage;Ljava/util/List;)Lde/justsoftware/chat/business/model/ChatMessage;", "Companion", "chat-service"})
public class ChatMessageService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageRepository chatMessageRepository;
    @NotNull
    private final ChatRepository chatRepository;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final Clock clock;
    @NotNull
    private static final Set<String> IMAGE_FORMATS;

    public ChatMessageService(@NotNull ChatService chatService, @NotNull ChatMessageRepository chatMessageRepository, @NotNull ChatRepository chatRepository, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull TransactionUtils transactionUtils, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageRepository, (String)"chatMessageRepository");
        Intrinsics.checkNotNullParameter((Object)chatRepository, (String)"chatRepository");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatService = chatService;
        this.chatMessageRepository = chatMessageRepository;
        this.chatRepository = chatRepository;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.transactionUtils = transactionUtils;
        this.clock = clock;
    }

    @Transactional
    @NotNull
    public ChatMessage create(@NotNull ChatMessage chatMessage, @NotNull List<? extends MultipartFile> files) throws ValidationException {
        ChatMessage chatMessage2;
        Intrinsics.checkNotNullParameter((Object)chatMessage, (String)"chatMessage");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ChatMessage chatMessage3 = chatMessage;
        if (chatMessage3 instanceof UserMessage) {
            chatMessage2 = files.isEmpty() ? this.createWithoutAttachments(chatMessage) : this.createWithAttachments((UserMessage)chatMessage, files);
        } else if (chatMessage3 instanceof SystemMessage) {
            chatMessage2 = this.createWithoutAttachments(chatMessage);
        } else {
            throw new ValidationException("Cannot create non-user-non-system message");
        }
        ChatMessage savedChatMessage = chatMessage2;
        boolean bl = false;
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        ChatMessage updatedChatMessage = Companion.access$copy((Companion)Companion, (ChatMessage)savedChatMessage, (Instant)instant);
        this.chatMessageRepository.updateUpdatedAt(updatedChatMessage.getId().getValue(), updatedChatMessage.getUpdatedAt());
        this.chatService.updateOnNewMessage(updatedChatMessage);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        return updatedChatMessage;
    }

    public static /* synthetic */ ChatMessage create$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return chatMessageService.create(chatMessage, list);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public ChatMessage delete(@NotNull ChatMessageId chatMessageId, @NotNull ProfileId profileId) throws ValidationException {
        ChatMessage chatMessage;
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        UserMessage chatMessage2 = this.validatedMessageForDelete(chatMessageId, profileId);
        Intrinsics.checkNotNullExpressionValue((Object)chatMessage2, (String)"chatMessage");
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)((ChatMessage)UserMessage.Companion.toDeletedMessage(chatMessage2)), null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatMessageRepository\n  \u2026sage().toDbChatMessage())");
        ChatMessage savedChatMessage = chatMessage = DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
        boolean bl = false;
        Set set = SetsKt.setOf((Object)savedChatMessage.getChatId().getValue());
        Instant instant = this.clock.instant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
        this.chatRepository.updateSyncDateByChatIds(set, instant);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        if (!((Collection)chatMessage2.getAttachments()).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = chatMessage2.getAttachments();
            DriveService driveService = this.driveService;
            boolean $i$f$map = false;
            void var10_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ChatMessageAttachment chatMessageAttachment = (ChatMessageAttachment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getDocumentId());
            }
            driveService.deleteFiles((List)destination$iv$iv, chatMessage2.getAuthor());
        }
        return chatMessage;
    }

    @Transactional
    @NotNull
    public Optional<ChatMessage> findById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Optional<ChatMessage> optional = this.chatMessageRepository.findById((Object)id.getValue()).map(ChatMessageService::findById$lambda-3);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"chatMessageRepository\n  \u2026ap { it.toChatMessage() }");
        return optional;
    }

    @Transactional
    @NotNull
    public ChatMessage getById(@NotNull ChatMessageId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object t = this.findById(id).orElseThrow(() -> ChatMessageService.getById$lambda-4(id));
        Intrinsics.checkNotNullExpressionValue(t, (String)"findById(id)\n           \u2026d $id does not exist.\") }");
        return (ChatMessage)t;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ChatMessageId, ChatMessage> findByIds(@NotNull Set<ChatMessageId> ids) {
        void $this$associateTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable iterable = ids;
        ChatMessageRepository chatMessageRepository = this.chatMessageRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (ChatMessageId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        List list = chatMessageRepository.findAllById((Iterable)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"chatMessageRepository\n  \u2026ap(ChatMessageId::value))");
        Iterable $this$associate$iv = list;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        $this$mapTo$iv$iv = $this$associate$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            DbChatMessage dbChatMessage = (DbChatMessage)element$iv$iv;
            boolean bl = false;
            ChatMessageId chatMessageId = new ChatMessageId(dbChatMessage.getId());
            Intrinsics.checkNotNullExpressionValue((Object)dbChatMessage, (String)"dbChatMessage");
            Pair pair = TuplesKt.to((Object)chatMessageId, (Object)DbChatMessage.Companion.toChatMessage(dbChatMessage));
            object.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public Sequence<ChatMessage> findAllUserMessages() {
        return RepositoryUtilKt.pageableSequence$default((int)10000, null, (Function1)((Function1)new /* Unavailable Anonymous Inner Class!! */), (int)2, null);
    }

    @Transactional
    @NotNull
    public Page<ChatMessage> getMessages(@NotNull ChatId chatId, int limit, @NotNull LoadDirection loadDirection, @Nullable Instant offsetTimestamp, @Nullable AttachmentFilter attachmentFilter) {
        Pageable pageable;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        if (loadDirection == LoadDirection.OLDER) {
            stringArray = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])stringArray));
        } else {
            stringArray = new String[]{"createdAt"};
            pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortAsc((String[])stringArray));
        }
        Pageable pageable2 = pageable;
        Specification offsetTimestampSpec = loadDirection == LoadDirection.OLDER ? ChatMessageSpecifications.INSTANCE.withCreatedAtLessThan(offsetTimestamp) : ChatMessageSpecifications.INSTANCE.witCreatedAtGreaterThan(offsetTimestamp);
        Specification specification = ChatMessageSpecifications.INSTANCE.withChatId(chatId.getValue()).and(offsetTimestampSpec).and(ChatMessageSpecifications.INSTANCE.withAttachments(attachmentFilter));
        Page page = this.chatMessageRepository.findAll(specification, pageable2).map(ChatMessageService::getMessages$lambda-6);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"chatMessageRepository.fi\u2026ap { it.toChatMessage() }");
        return page;
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageService chatMessageService, ChatId chatId, int n, LoadDirection loadDirection, Instant instant, AttachmentFilter attachmentFilter, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 4) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 8) != 0) {
            instant = null;
        }
        if ((n2 & 0x10) != 0) {
            attachmentFilter = null;
        }
        return chatMessageService.getMessages(chatId, n, loadDirection, instant, attachmentFilter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessage> getRecentMessages(@NotNull Collection<ChatId> chatIds2, @Nullable Instant updatedSince, int limit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(chatIds2, (String)"chatIds");
        if (!(chatIds2.size() <= 1000)) {
            boolean $i$a$-require-ChatMessageService$getRecentMessages$22 = false;
            String $i$a$-require-ChatMessageService$getRecentMessages$22 = "Got " + chatIds2.size() + " chat IDs, but only 1000 are allowed in a WHERE-IN-clause";
            throw new IllegalArgumentException($i$a$-require-ChatMessageService$getRecentMessages$22.toString());
        }
        Iterable $i$a$-require-ChatMessageService$getRecentMessages$22 = chatIds2;
        ChatMessageSpecifications chatMessageSpecifications = ChatMessageSpecifications.INSTANCE;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ChatId chatId = (ChatId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getValue());
        }
        Specification specification = chatMessageSpecifications.withChatIdIn((Collection)((List)destination$iv$iv)).and(ChatMessageSpecifications.INSTANCE.withUpdatedAtGreaterThan(updatedSince));
        String[] stringArray = new String[]{"createdAt"};
        Pageable pageable = Offset.Companion.toPageable((Offset)new LimitOffset(0L, limit, 1, null), PagingUtilsKt.sortDesc((String[])stringArray));
        Page page = this.chatMessageRepository.findAll(specification, pageable).map(ChatMessageService::getRecentMessages$lambda-9);
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"chatMessageRepository.fi\u2026ap { it.toChatMessage() }");
        return page;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ProfileId> findUpdatedAuthors(@NotNull Iterable<? extends ParticipantId> participantIds, @NotNull Instant since) {
        String p0;
        Iterable $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(participantIds, (String)"participantIds");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Iterable<? extends ParticipantId> iterable = participantIds;
        Object object = this.chatMessageRepository;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ParticipantId participantId = (ParticipantId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$mapToSet$iv = object.findUpdatedAuthorsByParticipantIds((Iterable)((List)destination$iv$iv), since);
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            p0 = (String)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(ProfileId.Companion.fromCanonicalId((String)it));
        }
        return (Set)destination$iv$iv;
    }

    @EventListener
    public void onChatUpdatedEvent(@NotNull ChatUpdatedEvent chatUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatUpdatedEvent, (String)"chatUpdatedEvent");
        ChatUpdatedEvent $this$onChatUpdatedEvent_u24lambda_u2d12 = chatUpdatedEvent;
        boolean bl = false;
        if ($this$onChatUpdatedEvent_u24lambda_u2d12.getOldChat() instanceof MultiUserChat && $this$onChatUpdatedEvent_u24lambda_u2d12.getNewChat() instanceof MultiUserChat && !Intrinsics.areEqual((Object)((MultiUserChat)$this$onChatUpdatedEvent_u24lambda_u2d12.getOldChat()).getTitle(), (Object)((MultiUserChat)$this$onChatUpdatedEvent_u24lambda_u2d12.getNewChat()).getTitle())) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatUpdatedEvent_u24lambda_u2d12.getOldChat().getId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatTitleChanged(((MultiUserChat)$this$onChatUpdatedEvent_u24lambda_u2d12.getOldChat()).getTitle(), ((MultiUserChat)$this$onChatUpdatedEvent_u24lambda_u2d12.getNewChat()).getTitle());
            ProfileId profileId = $this$onChatUpdatedEvent_u24lambda_u2d12.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    @EventListener
    public void onChatCreatedEvent(@NotNull ChatCreatedEvent chatCreatedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatCreatedEvent, (String)"chatCreatedEvent");
        ChatCreatedEvent $this$onChatCreatedEvent_u24lambda_u2d13 = chatCreatedEvent;
        boolean bl = false;
        if ($this$onChatCreatedEvent_u24lambda_u2d13.getChat() instanceof MultiUserChat) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$onChatCreatedEvent_u24lambda_u2d13.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.ChatCreated(((MultiUserChat)$this$onChatCreatedEvent_u24lambda_u2d13.getChat()).getTitle());
            ProfileId profileId = $this$onChatCreatedEvent_u24lambda_u2d13.getCreator();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    @EventListener
    public void onChatParticipantsChangedEvent(@NotNull ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        Intrinsics.checkNotNullParameter((Object)chatParticipantsChangedEvent, (String)"chatParticipantsChangedEvent");
        ChatParticipantsChangedEvent $this$onChatParticipantsChangedEvent_u24lambda_u2d14 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$onChatParticipantsChangedEvent_u24lambda_u2d14.getWithSystemMessage()) {
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2d14.getParticipantsRemoved()).isEmpty()) {
                this.sendSystemMessageForRemovedParticipants(chatParticipantsChangedEvent);
            }
            if (!((Collection)$this$onChatParticipantsChangedEvent_u24lambda_u2d14.getParticipantsAdded()).isEmpty()) {
                this.sendSystemMessageForAddedParticipants(chatParticipantsChangedEvent);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendSystemMessageForRemovedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getUpdater() == null) {
            this.handleDeletedParticipants($this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15);
        } else {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstanceToSet$iv = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getParticipantsRemoved();
            boolean $i$f$filterIsInstanceToSet = false;
            Iterable iterable = $this$filterIsInstanceToSet$iv;
            Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ProfileId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set removedProfileIdsStayingInUserGroups = SetsKt.minus((Set)((Set)destination$iv$iv), (Iterable)$this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getEffectiveProfileIdsRemoved());
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.RemovedFromChat($this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getParticipantsRemoved(), removedProfileIdsStayingInUserGroups);
            ProfileId profileId = $this$sendSystemMessageForRemovedParticipants_u24lambda_u2d15.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    private void sendSystemMessageForAddedParticipants(ChatParticipantsChangedEvent chatParticipantsChangedEvent) {
        ChatParticipantsChangedEvent $this$sendSystemMessageForAddedParticipants_u24lambda_u2d16 = chatParticipantsChangedEvent;
        boolean bl = false;
        if ($this$sendSystemMessageForAddedParticipants_u24lambda_u2d16.getUpdater() != null && !$this$sendSystemMessageForAddedParticipants_u24lambda_u2d16.isNewChat()) {
            ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
            ChatId chatId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2d16.getChatId();
            ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.AddedToChat($this$sendSystemMessageForAddedParticipants_u24lambda_u2d16.getParticipantsAdded());
            ProfileId profileId = $this$sendSystemMessageForAddedParticipants_u24lambda_u2d16.getUpdater();
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
            Instant instant2 = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
            ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
        }
    }

    private ChatMessage createWithoutAttachments(ChatMessage chatMessage) throws ValidationException {
        Object object = this.chatMessageRepository.save((Object)DbChatMessage.Companion.toDbChatMessage$default((DbChatMessage.Companion)DbChatMessage.Companion, (ChatMessage)ChatMessageService.validatedForCreate$default((ChatMessageService)this, (ChatMessage)chatMessage, null, (int)1, null), null, (int)1, null));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"chatMessageRepository\n  \u2026eate().toDbChatMessage())");
        return DbChatMessage.Companion.toChatMessage((DbChatMessage)object);
    }

    private ChatMessage createWithAttachments(UserMessage chatMessage, List<? extends MultipartFile> files) throws ValidationException {
        if (chatMessage.getMessage() != null) {
            throw new ValidationException("Message text must be null");
        }
        if (files.size() > 1) {
            throw new ValidationException("Only one attachment may be uploaded at a time");
        }
        return (ChatMessage)this.driveService.uploadFiles(files, chatMessage.getChatId(), chatMessage.getAuthor(), (Function1)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void handleDeletedParticipants(ChatParticipantsChangedEvent $this$handleDeletedParticipants) {
        if ($this$handleDeletedParticipants.getParticipantsRemoved().size() == 1) {
            ParticipantId removedParticipant = (ParticipantId)CollectionsKt.first((Iterable)$this$handleDeletedParticipants.getParticipantsRemoved());
            if (removedParticipant instanceof ProfileId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.PersonDeleted((ProfileId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                Instant instant2 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"now()");
                ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant2)), null, (int)2, null);
            } else if (removedParticipant instanceof UserGroupId) {
                ChatMessageId chatMessageId = ChatMessageId.Companion.generate();
                ChatId chatId = $this$handleDeletedParticipants.getChatId();
                ChatMessagePayload chatMessagePayload = (ChatMessagePayload)new ChatMessagePayload.UserGroupDeleted((UserGroupId)removedParticipant);
                ProfileId profileId = ProfileId.Companion.getDELETED_USER();
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                Instant instant3 = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"now()");
                ChatMessageService.create$default((ChatMessageService)this, (ChatMessage)((ChatMessage)new SystemMessage(chatMessageId, chatId, chatMessagePayload, profileId, instant, instant3)), null, (int)2, null);
            }
        }
    }

    private <T extends ChatMessage> T validatedForCreate(T $this$validatedForCreate, List<? extends DbChatMessageAttachment> attachments) throws ValidationException {
        CharSequence charSequence;
        T t;
        T $this$validatedForCreate_u24lambda_u2d17 = t = $this$validatedForCreate;
        boolean bl = false;
        if ($this$validatedForCreate_u24lambda_u2d17 instanceof UserMessage && attachments.isEmpty() && ((charSequence = (CharSequence)((UserMessage)$this$validatedForCreate_u24lambda_u2d17).getMessage()) == null || charSequence.length() == 0)) {
            throw new ValidationException("User message without text or attachments not allowed.");
        }
        if (this.chatMessageRepository.existsById((Object)$this$validatedForCreate_u24lambda_u2d17.getId().getValue())) {
            throw new ChatMessageAlreadyExistsException($this$validatedForCreate_u24lambda_u2d17.getId(), "Chat message with id " + $this$validatedForCreate_u24lambda_u2d17.getId() + " already exists.");
        }
        return t;
    }

    static /* synthetic */ ChatMessage validatedForCreate$default(ChatMessageService chatMessageService, ChatMessage chatMessage, List list, int n, Object object) throws ValidationException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: validatedForCreate");
        }
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        return chatMessageService.validatedForCreate(chatMessage, list);
    }

    private UserMessage validatedMessageForDelete(ChatMessageId chatMessageId, ProfileId profileId) throws ValidationException {
        Optional $this$filterIsInstance$iv = this.findById(chatMessageId);
        boolean $i$f$filterIsInstance = false;
        Optional optional = $this$filterIsInstance$iv.map((Function)validatedMessageForDelete$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"map { if (it is R) it else null }");
        return optional.filter(arg_0 -> ChatMessageService.validatedMessageForDelete$lambda-18(profileId, arg_0)).orElseThrow(() -> ChatMessageService.validatedMessageForDelete$lambda-19(chatMessageId));
    }

    private static final ChatMessage findById$lambda-3(DbChatMessage it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final NotFoundException getById$lambda-4(ChatMessageId $id) {
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        return new NotFoundException("Chat message with id " + $id + " does not exist.");
    }

    private static final ChatMessage getMessages$lambda-6(DbChatMessage it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final ChatMessage getRecentMessages$lambda-9(DbChatMessage it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return DbChatMessage.Companion.toChatMessage(it);
    }

    private static final boolean validatedMessageForDelete$lambda-18(ProfileId $profileId, UserMessage it) {
        Intrinsics.checkNotNullParameter((Object)$profileId, (String)"$profileId");
        return Intrinsics.areEqual((Object)it.getAuthor(), (Object)$profileId);
    }

    private static final ValidationException validatedMessageForDelete$lambda-19(ChatMessageId $chatMessageId) {
        Intrinsics.checkNotNullParameter((Object)$chatMessageId, (String)"$chatMessageId");
        return new ValidationException("ChatMessage with id " + $chatMessageId + " could not be deleted");
    }

    public static final /* synthetic */ TransactionUtils access$getTransactionUtils$p(ChatMessageService $this) {
        return $this.transactionUtils;
    }

    public static final /* synthetic */ ChatMessageRepository access$getChatMessageRepository$p(ChatMessageService $this) {
        return $this.chatMessageRepository;
    }

    public static final /* synthetic */ ChatMessage access$validatedForCreate(ChatMessageService $this, ChatMessage $receiver, List attachments) {
        return $this.validatedForCreate($receiver, attachments);
    }

    public static final /* synthetic */ Set access$getIMAGE_FORMATS$cp() {
        return IMAGE_FORMATS;
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ChatMessageService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ ChatService access$getChatService$p(ChatMessageService $this) {
        return $this.chatService;
    }

    static {
        Object[] objectArray = new String[]{"image/bmp", "image/gif", "image/jpeg", "image/png", "image/x-png", "image/tiff", "image/webp"};
        IMAGE_FORMATS = SetsKt.setOf((Object[])objectArray);
    }
}

