/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChangesService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.UserGroupService;
import de.justsoftware.chat.business.model.ChangeQuery;
import de.justsoftware.chat.business.model.Changes;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0019\u001a\u001b\u001cB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lde/justsoftware/chat/business/ChangesService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "userGroupService", "Lde/justsoftware/chat/business/UserGroupService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/UserGroupService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/business/ChatReadDateService;)V", "getChanges", "Lde/justsoftware/chat/business/model/Changes;", "query", "Lde/justsoftware/chat/business/model/ChangeQuery;", "profileId", "Lde/justsoftware/chat/model/ProfileId;", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "ChangesCommand", "Companion", "FullChangesCommand", "IncrementalChangesCommand", "chat-service"})
public class ChangesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    private static final int MAX_CHATS_IN_CHANGES = 500;
    private static final int MAX_MESSAGES_IN_CHANGES = 2000;

    public ChangesService(@NotNull ChatService chatService, @NotNull ChatMessageService chatMessageService, @NotNull ChatParticipantService chatParticipantService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull ChatSettingsService chatSettingsService, @NotNull ChatReadDateService chatReadDateService) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        this.chatService = chatService;
        this.chatMessageService = chatMessageService;
        this.chatParticipantService = chatParticipantService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.chatSettingsService = chatSettingsService;
        this.chatReadDateService = chatReadDateService;
    }

    @NotNull
    public Changes getChanges(@NotNull ChangeQuery query, @NotNull ProfileId profileId, @NotNull TenantId tenantId) {
        ChangesCommand changesCommand;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        ChangeQuery changeQuery = query;
        if (changeQuery instanceof ChangeQuery.All) {
            changesCommand = (ChangesCommand)new FullChangesCommand(this, profileId, tenantId);
        } else if (changeQuery instanceof ChangeQuery.Changed) {
            changesCommand = (ChangesCommand)new IncrementalChangesCommand(this, profileId, tenantId, ((ChangeQuery.Changed)query).getSince(), false);
        } else if (changeQuery instanceof ChangeQuery.ChangedOrUncertain) {
            changesCommand = (ChangesCommand)new IncrementalChangesCommand(this, profileId, tenantId, ((ChangeQuery.ChangedOrUncertain)query).getSince(), true);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ChangesCommand command = changesCommand;
        return command.execute();
    }

    public static final /* synthetic */ ChatService access$getChatService$p(ChangesService $this) {
        return $this.chatService;
    }

    public static final /* synthetic */ ChatParticipantService access$getChatParticipantService$p(ChangesService $this) {
        return $this.chatParticipantService;
    }

    public static final /* synthetic */ ChatMessageService access$getChatMessageService$p(ChangesService $this) {
        return $this.chatMessageService;
    }

    public static final /* synthetic */ ProfileService access$getProfileService$p(ChangesService $this) {
        return $this.profileService;
    }

    public static final /* synthetic */ UserGroupService access$getUserGroupService$p(ChangesService $this) {
        return $this.userGroupService;
    }

    public static final /* synthetic */ ChatSettingsService access$getChatSettingsService$p(ChangesService $this) {
        return $this.chatSettingsService;
    }

    public static final /* synthetic */ ChatReadDateService access$getChatReadDateService$p(ChangesService $this) {
        return $this.chatReadDateService;
    }
}

