/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.SearchApplicationService;
import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.application.model.ChatSearchResultDto;
import de.justsoftware.chat.application.model.ChatSettingsDto;
import de.justsoftware.chat.application.model.CommonCoreSearchResultDto;
import de.justsoftware.chat.application.model.MessageSearchResultDto;
import de.justsoftware.chat.application.model.MultiUserChatDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.ProfileSearchResultDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatCoreSearchService;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.CommonCoreSearchService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.model.ChatCoreSearchResult;
import de.justsoftware.chat.model.ChatCoreSearchSortType;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatType;
import de.justsoftware.chat.model.CommonCoreSearchModelType;
import de.justsoftware.chat.model.CommonCoreSearchResult;
import de.justsoftware.chat.model.CommonCoreSearchSortType;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.PageOffset;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ@\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016JN\u0010\u001d\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00110#*\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0012J0\u0010&\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\b\u0001\u0012\u00020\u0001\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e0#*\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lde/justsoftware/chat/application/SearchApplicationService;", "", "commonCoreSearchService", "Lde/justsoftware/chat/business/CommonCoreSearchService;", "chatCoreSearchService", "Lde/justsoftware/chat/business/ChatCoreSearchService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "(Lde/justsoftware/chat/business/CommonCoreSearchService;Lde/justsoftware/chat/business/ChatCoreSearchService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ChatParticipantService;)V", "searchMessages", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/MessageSearchResultDto;", "query", "", "chatId", "Lde/justsoftware/chat/model/ChatId;", "sortType", "Lde/justsoftware/chat/model/ChatCoreSearchSortType;", "page", "", "pageSize", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "suggestChat", "Lde/justsoftware/chat/application/model/CommonCoreSearchResultDto;", "Lde/justsoftware/chat/model/CommonCoreSearchSortType;", "onlyPersonResults", "", "toChatCoreSearchResultDtos", "", "", "Lde/justsoftware/chat/model/ChatCoreSearchResult;", "toCommonCoreSearchResultDtos", "Lde/justsoftware/chat/model/CommonCoreSearchResult;", "chat-service"})
public class SearchApplicationService {
    @NotNull
    private final CommonCoreSearchService commonCoreSearchService;
    @NotNull
    private final ChatCoreSearchService chatCoreSearchService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ChatParticipantService chatParticipantService;

    public SearchApplicationService(@NotNull CommonCoreSearchService commonCoreSearchService, @NotNull ChatCoreSearchService chatCoreSearchService, @NotNull ProfileService profileService, @NotNull ChatService chatService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ChatParticipantService chatParticipantService) {
        Intrinsics.checkNotNullParameter((Object)commonCoreSearchService, (String)"commonCoreSearchService");
        Intrinsics.checkNotNullParameter((Object)chatCoreSearchService, (String)"chatCoreSearchService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        this.commonCoreSearchService = commonCoreSearchService;
        this.chatCoreSearchService = chatCoreSearchService;
        this.profileService = profileService;
        this.chatService = chatService;
        this.chatLocalizationService = chatLocalizationService;
        this.chatParticipantService = chatParticipantService;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<CommonCoreSearchResultDto<? extends Object, ? extends Object>> suggestChat(@NotNull String query, @NotNull CommonCoreSearchSortType sortType, int page, int pageSize, @NotNull AuthorizationContext authContext, boolean onlyPersonResults) {
        void $this$mapContent$iv;
        CommonCoreSearchModelType[] commonCoreSearchModelTypeArray;
        CommonCoreSearchModelType[] commonCoreSearchModelTypeArray2;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        if (onlyPersonResults) {
            commonCoreSearchModelTypeArray2 = new Page[]{CommonCoreSearchModelType.PERSON};
            commonCoreSearchModelTypeArray = commonCoreSearchModelTypeArray2;
        } else {
            commonCoreSearchModelTypeArray2 = new CommonCoreSearchModelType[]{CommonCoreSearchModelType.CHAT, CommonCoreSearchModelType.PERSON};
            commonCoreSearchModelTypeArray = commonCoreSearchModelTypeArray2;
        }
        commonCoreSearchModelTypeArray2 = this.commonCoreSearchService.suggestChat(query, commonCoreSearchModelTypeArray, sortType, authContext.getProfileId(), (Offset)new PageOffset(page, pageSize));
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toCommonCoreSearchResultDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private List<CommonCoreSearchResultDto<? extends Object, ? extends Object>> toCommonCoreSearchResultDtos(Iterable<CommonCoreSearchResult> $this$toCommonCoreSearchResultDtos, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv$iv2;
        void $this$mapNotNullTo$iv$iv2;
        Iterable<CommonCoreSearchResult> $this$mapNotNullToSet$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet = false;
        Iterable<CommonCoreSearchResult> iterable = $this$mapNotNullToSet$iv;
        Iterable<Object> destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv) {
            ProfileId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv2;
            boolean bl = false;
            CommonCoreSearchResult p0 = (CommonCoreSearchResult)element$iv$iv;
            boolean bl2 = false;
            if (p0.getProfileId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set profileIds = (Set)destination$iv$iv;
        Iterable<CommonCoreSearchResult> $this$mapNotNullToSet$iv2 = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$mapNotNullToSet22 = false;
        destination$iv$iv = $this$mapNotNullToSet$iv2;
        Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize($this$mapNotNullToSet$iv2));
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        element$iv$iv$iv2 = $this$forEach$iv$iv$iv2.iterator();
        while (element$iv$iv$iv2.hasNext()) {
            ChatId it$iv$iv;
            Object element$iv$iv$iv3;
            Object element$iv$iv = element$iv$iv$iv3 = element$iv$iv$iv2.next();
            boolean bl = false;
            CommonCoreSearchResult p0 = (CommonCoreSearchResult)element$iv$iv;
            boolean bl4 = false;
            if (p0.getChatId() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set chatIds2 = (Set)destination$iv$iv2;
        Map $i$f$mapNotNullToSet22 = this.profileService.findByIds(profileIds);
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv4 : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv4;
            Map p0 = destination$iv$iv3;
            boolean bl6 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv4;
            Object k = it$iv$iv.getKey();
            object = p0;
            boolean bl7 = false;
            Profile profile = (Profile)entry.getValue();
            ProfileDto profileDto = ProfileDto.Companion.toProfileDto(profile);
            object.put(k, profileDto);
        }
        Map profileDtos = destination$iv$iv3;
        Map allowedActions = authContext.toMultiUserChatsAllowedActionsWithoutTemporaryPermissions(chatIds2);
        Map oneOnOneChatIdByChatPartnerIds = this.chatParticipantService.getOneOnOneChatIdByChatPartnerIds(profileIds, authContext.getProfileId());
        Iterable<CommonCoreSearchResult> $this$map$iv = $this$toCommonCoreSearchResultDtos;
        boolean $i$f$map = false;
        Iterable<CommonCoreSearchResult> $i$f$mapValuesTo22 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CommonCoreSearchResultDto commonCoreSearchResultDto;
            void searchResult;
            CommonCoreSearchResult it$iv$iv = (CommonCoreSearchResult)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[searchResult.getModelType().ordinal()]) {
                case 1: {
                    ProfileId profileId = ProfileId.Companion.fromCanonicalId(searchResult.getId());
                    ProfileSearchResultDto.Companion companion = ProfileSearchResultDto.Companion;
                    void v1 = searchResult;
                    Object v = profileDtos.get(profileId);
                    if (v == null) {
                        void var18_47 = v1;
                        ProfileSearchResultDto.Companion companion2 = companion;
                        boolean bl8 = false;
                        String string2 = "Could not load Profile with id " + profileId;
                        ProfileSearchResultDto.Companion companion3 = companion2;
                        void v4 = var18_47;
                        String string3 = string2;
                        throw new IllegalStateException(string3.toString());
                    }
                    commonCoreSearchResultDto = (CommonCoreSearchResultDto)companion.toProfileSearchResultDto((CommonCoreSearchResult)v1, (ProfileDto)v, (ChatId)oneOnOneChatIdByChatPartnerIds.get(profileId));
                    break;
                }
                case 2: {
                    Object object2;
                    ChatId chatId = ChatId.Companion.fromCanonicalId(searchResult.getId());
                    String string4 = searchResult.getChatType();
                    if (string4 == null) {
                        boolean $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22 = false;
                        String $i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22 = "ChatType is null for a chat searchResult";
                        throw new IllegalStateException($i$a$-checkNotNull-SearchApplicationService$toCommonCoreSearchResultDtos$1$chatType$22.toString());
                    }
                    ChatType chatType = ChatType.valueOf((String)string4);
                    if (!(chatType == ChatType.MULTI_USER_CHAT)) {
                        boolean bl9 = false;
                        String string5 = "OneOnOne Chats should be filtered by search queries, since oneOnOne chats should be handled as a person (chat partner)";
                        throw new IllegalStateException(string5.toString());
                    }
                    String string6 = searchResult.getName();
                    Object v = allowedActions.get(chatId);
                    if (v == null) {
                        object2 = "Required value was null.";
                        throw new IllegalStateException(object2.toString());
                    }
                    AllowedActions allowedActions2 = (AllowedActions)v;
                    Instant instant = searchResult.getModifyDate().toInstant();
                    object2 = searchResult.getModifyDate().toInstant();
                    ChatSettingsDto chatSettingsDto = ChatSettingsDto.Companion.toChatSettingsDto(new ChatSettings(chatId, authContext.getProfileId(), false, null, 12, null));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant()");
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"toInstant()");
                    commonCoreSearchResultDto = (CommonCoreSearchResultDto)ChatSearchResultDto.Companion.toChatSearchResultDto((CommonCoreSearchResult)searchResult, new MultiUserChatDto(chatId, string6, allowedActions2, null, 0L, instant, (Instant)object2, chatSettingsDto));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object.add(commonCoreSearchResultDto);
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<MessageSearchResultDto> searchMessages(@NotNull String query, @Nullable ChatId chatId, @NotNull ChatCoreSearchSortType sortType, int page, int pageSize, @NotNull AuthorizationContext authContext) {
        void $this$mapContent$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatCoreSearchService chatCoreSearchService = this.chatCoreSearchService;
        ProfileId profileId = authContext.getProfileId();
        PageOffset pageOffset = new PageOffset(page, pageSize);
        chatCoreSearchService = chatCoreSearchService.searchMessages(query, chatId, profileId, (Offset)pageOffset, sortType);
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toChatCoreSearchResultDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    /*
     * WARNING - void declaration
     */
    private List<MessageSearchResultDto> toChatCoreSearchResultDtos(Iterable<ChatCoreSearchResult> $this$toChatCoreSearchResultDtos, AuthorizationContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<ChatCoreSearchResult> $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv2;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        void $this$mapNotNullToSet$iv;
        Iterable<ChatCoreSearchResult> iterable = $this$toChatCoreSearchResultDtos;
        ProfileService profileService = this.profileService;
        boolean $i$f$mapNotNullToSet232 = false;
        void var6_7 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Object t = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatCoreSearchResult p0 = (ChatCoreSearchResult)t;
            boolean bl2 = false;
            if (p0.getAuthorId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map authors = profileService.findByIds((Set)destination$iv$iv);
        Iterable<ChatCoreSearchResult> $i$f$mapNotNullToSet232 = $this$toChatCoreSearchResultDtos;
        profileService = this.chatService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv2;
        Iterable destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            element$iv$iv$iv = (ChatCoreSearchResult)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getChatId());
        }
        Map chats2 = profileService.findByIds((Set)destination$iv$iv2);
        Iterable $this$filterIsInstanceToSet$iv = chats2.values();
        boolean $i$f$filterIsInstanceToSet232 = false;
        destination$iv$iv2 = $this$filterIsInstanceToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$filterIsInstanceToSet$iv));
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof OneOnOneChat)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set oneOnOneChats = (Set)destination$iv$iv3;
        Iterable $i$f$filterIsInstanceToSet232 = oneOnOneChats;
        profileService = this.chatParticipantService;
        boolean $i$f$mapToSet2 = false;
        destination$iv$iv3 = $this$mapToSet$iv;
        Collection destination$iv$iv4 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object e : $this$mapTo$iv$iv) {
            void p0;
            Chat bl = (Chat)e;
            collection = destination$iv$iv4;
            boolean bl4 = false;
            collection.add(p0.getId());
        }
        Map oneOnOneChatPartnerByChatId = profileService.getDirectChatPartnersForProfile((Set)destination$iv$iv4, authContext.getProfileId());
        Iterable<ChatCoreSearchResult> $this$mapNotNull$iv = $this$toChatCoreSearchResultDtos;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            MessageSearchResultDto messageSearchResultDto;
            Object element$iv$iv$iv2;
            Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
            boolean bl2 = false;
            ChatCoreSearchResult searchResult = (ChatCoreSearchResult)element$iv$iv;
            boolean bl5 = false;
            if ((Chat)chats2.get(searchResult.getChatId()) == null) {
                messageSearchResultDto = null;
            } else if ((Profile)authors.get(searchResult.getAuthorId()) == null) {
                messageSearchResultDto = null;
            } else {
                Profile author;
                String string2;
                Chat chat;
                Chat chat2 = chat;
                if (chat2 instanceof OneOnOneChat) {
                    string2 = this.chatLocalizationService.localizeOneOnOneChatTitleWithPrefix((Profile)oneOnOneChatPartnerByChatId.get(chat.getId()), authContext);
                } else if (chat2 instanceof MultiUserChat) {
                    string2 = ((MultiUserChat)chat).getTitle();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                String chatTitle = string2;
                messageSearchResultDto = MessageSearchResultDto.Companion.toMessageSearchResultDto(searchResult, chatTitle, ProfileDto.Companion.toProfileDto(author));
            }
            if (messageSearchResultDto == null) continue;
            MessageSearchResultDto it$iv$iv = messageSearchResultDto;
            boolean bl6 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        return (List)destination$iv$iv5;
    }
}

