/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.application.model.SaveChatMessageDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.LoadDirection;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.NotFoundException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import de.justsoftware.chat.util.PagingUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JF\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lde/justsoftware/chat/application/ChatMessageApplicationService;", "", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "clock", "Ljava/time/Clock;", "(Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/business/ProfileService;Ljava/time/Clock;)V", "createChatMessage", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "saveChatMessageDto", "Lde/justsoftware/chat/application/model/SaveChatMessageDto;", "attachments", "", "Lorg/springframework/web/multipart/MultipartFile;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "deleteChatMessage", "", "chatMessageId", "Lde/justsoftware/chat/model/ChatMessageId;", "getChatMessage", "getMessages", "Lorg/springframework/data/domain/Page;", "offsetMessageId", "limit", "", "loadDirection", "Lde/justsoftware/chat/business/LoadDirection;", "includeOffsetMessage", "", "chat-service"})
public class ChatMessageApplicationService {
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final Clock clock;

    public ChatMessageApplicationService(@NotNull ChatMessageService chatMessageService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull ProfileService profileService, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatMessageService = chatMessageService;
        this.chatLocalizationService = chatLocalizationService;
        this.profileService = profileService;
        this.clock = clock;
    }

    @NotNull
    public ChatMessageDto createChatMessage(@NotNull ChatId chatId, @NotNull SaveChatMessageDto saveChatMessageDto, @NotNull List<? extends MultipartFile> attachments, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException, NotFoundException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)saveChatMessageDto, (String)"saveChatMessageDto");
        Intrinsics.checkNotNullParameter(attachments, (String)"attachments");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkWriteChat(chatId);
        ChatMessage chatMessage = this.chatMessageService.create((ChatMessage)SaveChatMessageDto.Companion.toUserMessage(saveChatMessageDto, chatId, authContext.getProfileId(), this.clock), attachments);
        return ChatMessageDto.Companion.toChatMessageDto(chatMessage, ProfileDto.Companion.toProfileDto(this.profileService.getById(chatMessage.getAuthor())), this.chatLocalizationService.localizeMessage(chatMessage, authContext));
    }

    public void deleteChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatMessageService.delete(chatMessageId, authContext.getProfileId());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatMessageDto> getMessages(@NotNull ChatId chatId, @Nullable ChatMessageId offsetMessageId, int limit, @NotNull LoadDirection loadDirection, boolean includeOffsetMessage, @NotNull AuthorizationContext authContext) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        ChatMessage offsetMessage;
        ChatMessage chatMessage;
        Object p0;
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)loadDirection, (String)"loadDirection");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageId chatMessageId = offsetMessageId;
        if (chatMessageId != null) {
            ChatMessageId chatMessageId2 = chatMessageId;
            ChatMessageService chatMessageService = this.chatMessageService;
            p0 = chatMessageId2;
            boolean bl = false;
            chatMessage = chatMessageService.getById(p0);
        } else {
            chatMessage = offsetMessage = null;
        }
        if (offsetMessage != null && !Intrinsics.areEqual((Object)offsetMessage.getChatId(), (Object)chatId)) {
            throw new NotFoundException("Message " + offsetMessageId + " is not found in chat " + chatId);
        }
        ChatMessage chatMessage2 = offsetMessage;
        Page messages2 = ChatMessageService.getMessages$default((ChatMessageService)this.chatMessageService, (ChatId)chatId, (int)limit, (LoadDirection)loadDirection, (Instant)(chatMessage2 != null ? chatMessage2.getCreatedAt() : null), null, (int)16, null);
        if (includeOffsetMessage && offsetMessage != null) {
            messages2 = PagingUtilsKt.addFirst((Page)messages2, (Object)offsetMessage);
        }
        List list = messages2.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"messages.content");
        p0 = list;
        ProfileService profileService = this.profileService;
        boolean $i$f$mapNotNullToSet = false;
        void var12_13 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProfileId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            ChatMessage p02 = (ChatMessage)element$iv$iv;
            boolean bl2 = false;
            if (p02.getAuthor() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map profiles2 = profileService.findByIds((Set)destination$iv$iv);
        Page page = messages2.map(arg_0 -> ChatMessageApplicationService.getMessages$lambda-1(profiles2, this, authContext, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page, (String)"messages\n            .ma\u2026          )\n            }");
        return page;
    }

    public static /* synthetic */ Page getMessages$default(ChatMessageApplicationService chatMessageApplicationService, ChatId chatId, ChatMessageId chatMessageId, int n, LoadDirection loadDirection, boolean bl, AuthorizationContext authorizationContext, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getMessages");
        }
        if ((n2 & 2) != 0) {
            chatMessageId = null;
        }
        if ((n2 & 8) != 0) {
            loadDirection = LoadDirection.OLDER;
        }
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        return chatMessageApplicationService.getMessages(chatId, chatMessageId, n, loadDirection, bl, authorizationContext);
    }

    @NotNull
    public ChatMessageDto getChatMessage(@NotNull ChatId chatId, @NotNull ChatMessageId chatMessageId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)chatMessageId, (String)"chatMessageId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        ChatMessageDto chatMessageDto = this.chatMessageService.findById(chatMessageId).filter(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda-2(chatId, arg_0)).map(arg_0 -> ChatMessageApplicationService.getChatMessage$lambda-3(this, authContext, arg_0)).orElseThrow(() -> ChatMessageApplicationService.getChatMessage$lambda-4(chatMessageId, chatId));
        Intrinsics.checkNotNullExpressionValue((Object)chatMessageDto, (String)"chatMessageService\n     \u2026xist for chat $chatId\") }");
        return chatMessageDto;
    }

    private static final ChatMessageDto getMessages$lambda-1(Map $profiles, ChatMessageApplicationService this$0, AuthorizationContext $authContext, ChatMessage chatMessage) {
        Intrinsics.checkNotNullParameter((Object)$profiles, (String)"$profiles");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullExpressionValue((Object)chatMessage, (String)"chatMessage");
        Profile profile = (Profile)$profiles.get(chatMessage.getAuthor());
        if (profile == null || (profile = ProfileDto.Companion.toProfileDto(profile)) == null) {
            throw new NotFoundException("User with id " + chatMessage.getAuthor() + " does not exist.");
        }
        return ChatMessageDto.Companion.toChatMessageDto(chatMessage, (ProfileDto)profile, this$0.chatLocalizationService.localizeMessage(chatMessage, $authContext));
    }

    private static final boolean getChatMessage$lambda-2(ChatId $chatId, ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return Intrinsics.areEqual((Object)it.getChatId(), (Object)$chatId);
    }

    private static final ChatMessageDto getChatMessage$lambda-3(ChatMessageApplicationService this$0, AuthorizationContext $authContext, ChatMessage chatMessage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$authContext, (String)"$authContext");
        Intrinsics.checkNotNullExpressionValue((Object)chatMessage, (String)"chatMessage");
        return ChatMessageDto.Companion.toChatMessageDto(chatMessage, ProfileDto.Companion.toProfileDto(this$0.profileService.getById(chatMessage.getAuthor())), this$0.chatLocalizationService.localizeMessage(chatMessage, $authContext));
    }

    private static final NotFoundException getChatMessage$lambda-4(ChatMessageId $chatMessageId, ChatId $chatId) {
        Intrinsics.checkNotNullParameter((Object)$chatMessageId, (String)"$chatMessageId");
        Intrinsics.checkNotNullParameter((Object)$chatId, (String)"$chatId");
        return new NotFoundException("ChatMessage with id " + $chatMessageId + " does not exist for chat " + $chatId);
    }
}

