/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.security;

import de.justsoftware.jwtfilter.ReactiveJwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.context.NoOpServerSecurityContextRepository;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.security.web.server.header.XFrameOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfiguration {
    private final String _monitoringResources;
    private final ReactiveJwtAuthenticationProcessingFilter _jwtAuthenticationProcessingFilter;

    @Autowired
    public WebSecurityConfiguration(JwtVerifier jwtVerifier) {
        this._monitoringResources = "/internal/monitoring/**";
        this._jwtAuthenticationProcessingFilter = new ReactiveJwtAuthenticationProcessingFilter(jwtVerifier);
        this._jwtAuthenticationProcessingFilter.applyIgnoreFilterMatcher((ServerWebExchangeMatcher)new PathPatternParserServerWebExchangeMatcher(this._monitoringResources)).applyAllowCookieOnlyVerificationMatcher(WebSecurityConfiguration::isGetRequest);
    }

    @Nonnull
    private static Mono<ServerWebExchangeMatcher.MatchResult> isGetRequest(ServerWebExchange exchange) {
        return HttpMethod.GET.equals((Object)exchange.getRequest().getMethod()) ? ServerWebExchangeMatcher.MatchResult.match() : ServerWebExchangeMatcher.MatchResult.notMatch();
    }

    @Bean
    @Nonnull
    public SecurityWebFilterChain springSecurityFilterChain(ServerHttpSecurity http) {
        ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)http.exceptionHandling().and().anonymous().and().headers().frameOptions().mode(XFrameOptionsServerHttpHeadersWriter.Mode.SAMEORIGIN).and().authorizeExchange().pathMatchers(new String[]{this._monitoringResources})).permitAll().and().authorizeExchange().anyExchange().authenticated().and().addFilterAt((WebFilter)this._jwtAuthenticationProcessingFilter, SecurityWebFiltersOrder.AUTHENTICATION).securityContextRepository((ServerSecurityContextRepository)NoOpServerSecurityContextRepository.getInstance());
        return http.build();
    }
}

