/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.security;

import de.justsoftware.jwtfilter.keys.KeyMaterialProvider;
import de.justsoftware.jwtfilter.keys.PublicKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import java.util.Base64;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ParametersAreNonnullByDefault
public class JwtConfig {
    private static final String ENVIRONMENT_KEY_FOR_JWT_PUBLIC_KEY = "jwt.publicKey";
    private static final String ENVIRONMENT_KEY_FOR_JWT_PRIVATE_KEY = "jwt.privateKey";
    private final PublicKeyCache _publicKeyCache;

    public JwtConfig(Environment environment) {
        KeyMaterialProvider privKeyProvider = () -> Optional.ofNullable(environment.getProperty(ENVIRONMENT_KEY_FOR_JWT_PRIVATE_KEY)).map(JwtConfig::decodeBytes);
        KeyMaterialProvider pubKeyProvider = () -> Optional.ofNullable(environment.getProperty(ENVIRONMENT_KEY_FOR_JWT_PUBLIC_KEY)).map(JwtConfig::decodeBytes);
        this._publicKeyCache = new PublicKeyCache(privKeyProvider, pubKeyProvider);
    }

    @Nonnull
    private static byte[] decodeBytes(String base64Encoded) {
        return Base64.getDecoder().decode(base64Encoded);
    }

    @Bean
    @Nonnull
    public JwtVerifier getJwtVerifier() {
        return JwtVerifiers.createEncryptedTokenVerifier((PublicKeyCache)this._publicKeyCache);
    }
}

