/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.browserpushservice.config;

import de.justsoftware.browserpushservice.exceptions.UnauthorizedException;
import de.justsoftware.browserpushservice.model.ProfileId;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@ParametersAreNonnullByDefault
public class SecurityContextHolderArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return ProfileId.class.isAssignableFrom(parameter.getParameterType());
    }

    public Mono<Object> resolveArgument(MethodParameter parameter, BindingContext bindingContext, ServerWebExchange exchange) {
        return ReactiveSecurityContextHolder.getContext().map(context -> {
            Authentication authentication = context.getAuthentication();
            if (authentication == null) {
                throw new UnauthorizedException("You must be logged in to perform this request.");
            }
            String profileId = (String)authentication.getPrincipal();
            return new ProfileId(profileId);
        });
    }
}

