/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.user.model.Profile;
import de.justsoftware.admin.domain.user.persistence.repository.ProfileRepository;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapper
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'JN\u0010\b\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u000fH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/ProfileMapper;", "Lde/justsoftware/admin/domain/user/persistence/repository/ProfileRepository;", "delete", "", "id", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "findOne", "Lde/justsoftware/admin/domain/user/model/Profile;", "insertOrUpdate", "firstname", "", "lastname", "email", "imageUrl", "active", "", "blocked", "admin-service"})
public interface ProfileMapper
extends ProfileRepository {
    @ConstructorArgs(value={@Arg(column="id", javaType=ProfileId.class), @Arg(column="firstName", javaType=String.class), @Arg(column="lastName", javaType=String.class), @Arg(column="email", javaType=String.class), @Arg(column="image_url", javaType=String.class), @Arg(column="active", javaType=boolean.class), @Arg(column="blocked", javaType=boolean.class), @Arg(column="tenant_id", javaType=TenantId.class)})
    @Select(value={"\n        SELECT * FROM profile p\n        LEFT OUTER JOIN profile_tenant pt\n        ON p.id = pt.profile_id\n        WHERE p.id = #{id}\n        "})
    @Nullable
    public Profile findOne(@Param(value="id") @NotNull ProfileId var1);

    @Insert(value={"<script>\n\n        <if test=\"_databaseId == 'POSTGRES'\">\n            INSERT INTO profile (id, firstname, lastname, email, image_url, active, blocked)\n                VALUES (#{id}, #{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n            ON CONFLICT(id)\n                DO UPDATE SET (firstname, lastname, email, image_url, active, blocked)\n                = (#{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n        </if>\n\n        <if test=\"_databaseId == 'ORACLE'\">\n            MERGE INTO profile p USING (SELECT #{id} as id from dual) s ON (s.id = p.id)\n            WHEN MATCHED THEN\n                UPDATE SET\n                    firstname = #{firstName},\n                    lastname = #{lastName},\n                    email = #{email},\n                    image_url = #{imageUrl},\n                    active = #{active},\n                    blocked = #{blocked}\n            WHEN NOT MATCHED THEN\n                INSERT (id, firstname, lastname, email, image_url, active, blocked)\n                VALUES (#{id}, #{firstName}, #{lastName}, #{email}, #{imageUrl}, #{active}, #{blocked})\n        </if>\n\n        </script>\n        "})
    public void insertOrUpdate(@Param(value="id") @NotNull ProfileId var1, @Param(value="firstName") @NotNull String var2, @Param(value="lastName") @NotNull String var3, @Param(value="email") @NotNull String var4, @Param(value="imageUrl") @NotNull String var5, @Param(value="active") boolean var6, @Param(value="blocked") boolean var7);

    @Delete(value={"DELETE FROM profile WHERE id = #{id}"})
    public void delete(@Param(value="id") @NotNull ProfileId var1);
}

