/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.appsettings.model.CoreApp;
import de.justsoftware.admin.domain.appsettings.persistence.AppSettingsRepository;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import java.util.List;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mapper
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\bg\u0018\u00002\u00020\u0001J\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H'J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0001\u0010\u0004\u001a\u00020\u0005H'J&\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\f\u001a\u00020\rH'J&\u0010\u000e\u001a\u00020\u000b2\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\f\u001a\u00020\rH'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/AppSettingsMapper;", "Lde/justsoftware/admin/domain/appsettings/persistence/AppSettingsRepository;", "findAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "app", "Lde/justsoftware/admin/domain/appsettings/model/CoreApp;", "getAllAppSettingsByTenantId", "", "updateColor", "", "color", "", "upsertAppSettings", "admin-service"})
public interface AppSettingsMapper
extends AppSettingsRepository {
    @Insert(value={"\n        <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                INSERT INTO app_settings (tenant_id, app, color)\n                    VALUES (#{tenantId}, #{app}, #{color})\n                ON CONFLICT(tenant_id, app)\n                    DO UPDATE SET color = #{color}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                MERGE INTO app_settings a\n                    USING (SELECT #{tenantId} as tenantId, #{app} as app from dual) s\n                        ON (s.tenantId = a.tenant_id AND s.app = a.app)\n                        WHEN MATCHED THEN\n                            UPDATE SET color = #{color}\n                        WHEN NOT MATCHED THEN\n                            INSERT (tenant_id, app, color)\n                            VALUES (#{tenantId}, #{app}, #{color})\n            </if>\n        </script>\n        "})
    public void upsertAppSettings(@Param(value="tenantId") @NotNull TenantId var1, @Param(value="app") @NotNull CoreApp var2, @Param(value="color") @NotNull String var3);

    @Select(value={"SELECT * FROM app_settings WHERE tenant_id = #{tenantId} AND app = #{app}"})
    @Nullable
    public AppSettings findAppSettings(@Param(value="tenantId") @NotNull TenantId var1, @Param(value="app") @NotNull CoreApp var2);

    @Select(value={"SELECT * FROM app_settings WHERE tenant_id = #{tenantId}"})
    @NotNull
    public List<AppSettings> getAllAppSettingsByTenantId(@Param(value="tenantId") @NotNull TenantId var1);

    @Update(value={"\n        UPDATE app_settings SET color = #{color}\n        WHERE tenant_id = #{tenantId} AND app = #{app}\n        "})
    public void updateColor(@Param(value="tenantId") @NotNull TenantId var1, @Param(value="app") @NotNull CoreApp var2, @Param(value="color") @NotNull String var3);
}

