/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.publisher;

import de.justsoftware.admin.domain.appsettings.model.AppPermission;
import de.justsoftware.admin.domain.appsettings.model.AppSettings;
import de.justsoftware.admin.domain.tenant.model.IdpConfiguration;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantInvitation;
import de.justsoftware.admin.domain.tenant.model.TenantPermission;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.kafka.publisher.model.KafkaPublishOperation;
import de.justsoftware.admin.kafka.publisher.producer.OauthClientProducer;
import de.justsoftware.admin.kafka.publisher.producer.PermissionConfigProducer;
import de.justsoftware.admin.kafka.publisher.producer.PermissionProducer;
import de.justsoftware.admin.kafka.publisher.producer.TenantProducer;
import de.justsoftware.admin.model.Role;
import de.justsoftware.admin.model.itemid.ItemId;
import de.justsoftware.admin.model.itemid.impl.ClientRegistrationId;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.generated.proto.ClientRegistration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0012J$\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016J.\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J>\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00122\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00122\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0015H\u0016J0\u0010+\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130,H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u000eH\u0016J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u000201H\u0016J$\u00102\u001a\u00020\u00172\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00130,2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00130,H\u0016J0\u00105\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010(2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0012H\u0016J$\u00106\u001a\u00020\u00172\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0015082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u001508H\u0016J\u0010\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0017H\u0013R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lde/justsoftware/admin/kafka/publisher/Publisher;", "", "permissionConfigProducer", "Lde/justsoftware/admin/kafka/publisher/producer/PermissionConfigProducer;", "permissionProducer", "Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;", "tenantProducer", "Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;", "oauthClientProducer", "Lde/justsoftware/admin/kafka/publisher/producer/OauthClientProducer;", "(Lde/justsoftware/admin/kafka/publisher/producer/PermissionConfigProducer;Lde/justsoftware/admin/kafka/publisher/producer/PermissionProducer;Lde/justsoftware/admin/kafka/publisher/producer/TenantProducer;Lde/justsoftware/admin/kafka/publisher/producer/OauthClientProducer;)V", "idpConfigToClientRegistration", "Lde/justsoftware/generated/proto/ClientRegistration;", "conf", "Lde/justsoftware/admin/domain/tenant/model/IdpConfiguration;", "publishDeletedProfile", "Lde/justsoftware/admin/kafka/publisher/model/KafkaPublishOperation;", "appPermissions", "", "Lde/justsoftware/admin/domain/appsettings/model/AppPermission;", "tenantManagerPermissions", "Lde/justsoftware/admin/domain/tenant/model/TenantPermission;", "publishDeletedTenant", "", "tenantId", "Lde/justsoftware/admin/model/itemid/impl/TenantId;", "tenantPermissions", "publishDeletedUserGroup", "userGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "publishNewTenant", "tenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "tenantSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "allAppSettings", "Lde/justsoftware/admin/domain/appsettings/model/AppSettings;", "tenantManagers", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "tenantInvitation", "Lde/justsoftware/admin/domain/tenant/model/TenantInvitation;", "publishNewTenantPermission", "tenantPermission", "publishNewUserGroup", "", "publishOAuthClientChange", "idpConfig", "publishOAuthClientDeletion", "id", "Lde/justsoftware/admin/model/itemid/impl/ClientRegistrationId;", "publishUpdatedAppPermissions", "addedAppPermissions", "removedAppPermissions", "publishUpdatedTenant", "publishUpdatedTenantPermissions", "adds", "", "removes", "republishOAuthClients", "doRepublish", "Ljava/lang/Runnable;", "runAfterStartup", "admin-service"})
@SourceDebugExtension(value={"SMAP\nPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Publisher.kt\nde/justsoftware/admin/kafka/publisher/Publisher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1549#2:231\n1620#2,3:232\n1549#2:235\n1620#2,3:236\n1549#2:239\n1620#2,3:240\n1855#2,2:243\n1855#2,2:245\n1549#2:247\n1620#2,3:248\n*S KotlinDebug\n*F\n+ 1 Publisher.kt\nde/justsoftware/admin/kafka/publisher/Publisher\n*L\n63#1:231\n63#1:232,3\n97#1:235\n97#1:236,3\n105#1:239\n105#1:240,3\n170#1:243,2\n171#1:245,2\n228#1:247\n228#1:248,3\n*E\n"})
public class Publisher {
    @NotNull
    private final PermissionConfigProducer permissionConfigProducer;
    @NotNull
    private final PermissionProducer permissionProducer;
    @NotNull
    private final TenantProducer tenantProducer;
    @NotNull
    private final OauthClientProducer oauthClientProducer;

    public Publisher(@NotNull PermissionConfigProducer permissionConfigProducer, @NotNull PermissionProducer permissionProducer, @NotNull TenantProducer tenantProducer, @NotNull OauthClientProducer oauthClientProducer) {
        Intrinsics.checkNotNullParameter((Object)permissionConfigProducer, (String)"permissionConfigProducer");
        Intrinsics.checkNotNullParameter((Object)permissionProducer, (String)"permissionProducer");
        Intrinsics.checkNotNullParameter((Object)tenantProducer, (String)"tenantProducer");
        Intrinsics.checkNotNullParameter((Object)oauthClientProducer, (String)"oauthClientProducer");
        this.permissionConfigProducer = permissionConfigProducer;
        this.permissionProducer = permissionProducer;
        this.tenantProducer = tenantProducer;
        this.oauthClientProducer = oauthClientProducer;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    private void runAfterStartup() {
        this.permissionConfigProducer.sendAppConfig$admin_service();
        this.permissionConfigProducer.sendTenantConfig$admin_service();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public KafkaPublishOperation publishNewTenant(@NotNull Tenant tenant, @NotNull TenantSettings tenantSettings, @NotNull List<AppSettings> allAppSettings, @NotNull List<? extends GranteeId> tenantManagers, @Nullable TenantInvitation tenantInvitation) {
        Collection<TenantPermission> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        Intrinsics.checkNotNullParameter(tenantManagers, (String)"tenantManagers");
        Object[] objectArray = new KafkaPublishOperation[5];
        TenantInvitation tenantInvitation2 = tenantInvitation;
        objectArray[0] = this.tenantProducer.publish$admin_service(tenant, CollectionsKt.toSet((Iterable)allAppSettings), tenantSettings, tenantInvitation2 != null ? tenantInvitation2.getTenantInvitationCode() : null);
        objectArray[1] = this.permissionProducer.registerTenant$admin_service(tenant.getId());
        objectArray[2] = this.permissionProducer.registerAllAppsForTenant$admin_service(tenant.getId());
        objectArray[3] = this.permissionProducer.allowMembersToReadTenant$admin_service(tenant.getId());
        Iterable iterable = tenantManagers;
        PermissionProducer permissionProducer = this.permissionProducer;
        int n = 4;
        Object[] objectArray2 = objectArray;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GranteeId granteeId = (GranteeId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TenantPermission(tenant.getId(), (GranteeId)it, Role.MANAGER));
        }
        collection = (List)destination$iv$iv;
        objectArray2[n] = permissionProducer.applyTenantPermissions$admin_service((Collection)collection);
        List operations = CollectionsKt.listOf((Object[])objectArray);
        return new KafkaPublishOperation(operations);
    }

    public void publishNewTenantPermission(@NotNull TenantPermission tenantPermission) {
        Intrinsics.checkNotNullParameter((Object)tenantPermission, (String)"tenantPermission");
        this.permissionProducer.applyTenantPermission$admin_service(tenantPermission);
    }

    public void publishNewUserGroup(@NotNull UserGroup userGroup, @NotNull Collection<TenantPermission> tenantPermissions, @NotNull Collection<AppPermission> appPermissions) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        this.permissionProducer.allowUserGroupToReadTenant$admin_service(userGroup);
        this.permissionProducer.applyTenantPermissions$admin_service(tenantPermissions);
        this.permissionProducer.applyAppPermissions$admin_service(appPermissions);
    }

    public static /* synthetic */ void publishNewUserGroup$default(Publisher publisher, UserGroup userGroup, Collection collection, Collection collection2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishNewUserGroup");
        }
        if ((n & 2) != 0) {
            collection = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            collection2 = SetsKt.emptySet();
        }
        publisher.publishNewUserGroup(userGroup, collection, collection2);
    }

    public void publishDeletedTenant(@NotNull TenantId tenantId, @NotNull List<TenantPermission> tenantPermissions, @NotNull List<AppPermission> appPermissions) {
        GranteeId it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter(tenantPermissions, (String)"tenantPermissions");
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        Iterable $this$map$iv = tenantPermissions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TenantPermission tenantPermission = (TenantPermission)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGranteeId());
        }
        List tenantManagerIds = (List)destination$iv$iv;
        this.tenantProducer.publishDeletedTenant(tenantId);
        this.permissionProducer.deleteAllAppsForTenant$admin_service(tenantId);
        this.permissionProducer.disallowMembersToReadTenant$admin_service(tenantId);
        this.permissionProducer.revokeAppPermissions$admin_service((Collection)appPermissions);
        $this$map$iv = tenantManagerIds;
        collection = this.permissionProducer;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (GranteeId)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new TenantPermission(tenantId, it, Role.MANAGER));
        }
        collection.revokeTenantPermissions$admin_service((List)destination$iv$iv);
        this.permissionProducer.deleteItem$admin_service((ItemId)tenantId);
    }

    public static /* synthetic */ void publishDeletedTenant$default(Publisher publisher, TenantId tenantId, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishDeletedTenant");
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        publisher.publishDeletedTenant(tenantId, list, list2);
    }

    @NotNull
    public KafkaPublishOperation publishDeletedProfile(@NotNull List<AppPermission> appPermissions, @NotNull List<TenantPermission> tenantManagerPermissions) {
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        Intrinsics.checkNotNullParameter(tenantManagerPermissions, (String)"tenantManagerPermissions");
        KafkaPublishOperation appPermissionOp = this.permissionProducer.revokeAppPermissions$admin_service((Collection)appPermissions);
        KafkaPublishOperation tenantManagerOps = this.permissionProducer.revokeTenantPermissions$admin_service((Collection)tenantManagerPermissions);
        Object[] objectArray = new KafkaPublishOperation[]{tenantManagerOps, appPermissionOp};
        return new KafkaPublishOperation(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public KafkaPublishOperation publishDeletedUserGroup(@NotNull UserGroup userGroup, @NotNull List<AppPermission> appPermissions) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        Intrinsics.checkNotNullParameter(appPermissions, (String)"appPermissions");
        Object[] objectArray = new KafkaPublishOperation[]{this.permissionProducer.disallowUserGroupToReadTenant$admin_service(userGroup), this.permissionProducer.revokeAppPermissions$admin_service((Collection)appPermissions)};
        return new KafkaPublishOperation(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public KafkaPublishOperation publishUpdatedTenant(@NotNull Tenant tenant, @NotNull TenantSettings tenantSettings, @Nullable TenantInvitation tenantInvitation, @NotNull List<AppSettings> allAppSettings) {
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter((Object)tenantSettings, (String)"tenantSettings");
        Intrinsics.checkNotNullParameter(allAppSettings, (String)"allAppSettings");
        TenantInvitation tenantInvitation2 = tenantInvitation;
        return this.tenantProducer.publish$admin_service(tenant, CollectionsKt.toSet((Iterable)allAppSettings), tenantSettings, tenantInvitation2 != null ? tenantInvitation2.getTenantInvitationCode() : null);
    }

    public void publishUpdatedAppPermissions(@NotNull Collection<AppPermission> addedAppPermissions, @NotNull Collection<AppPermission> removedAppPermissions) {
        Intrinsics.checkNotNullParameter(addedAppPermissions, (String)"addedAppPermissions");
        Intrinsics.checkNotNullParameter(removedAppPermissions, (String)"removedAppPermissions");
        this.permissionProducer.applyAppPermissions$admin_service(addedAppPermissions);
        this.permissionProducer.revokeAppPermissions$admin_service(removedAppPermissions);
    }

    public void publishUpdatedTenantPermissions(@NotNull Set<TenantPermission> adds, @NotNull Set<TenantPermission> removes) {
        TenantPermission it;
        Intrinsics.checkNotNullParameter(adds, (String)"adds");
        Intrinsics.checkNotNullParameter(removes, (String)"removes");
        Iterable $this$forEach$iv = adds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TenantPermission)element$iv;
            boolean bl = false;
            this.permissionProducer.applyTenantPermission$admin_service(it);
        }
        $this$forEach$iv = removes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TenantPermission)element$iv;
            boolean bl = false;
            this.permissionProducer.revokeTenantPermission$admin_service(it);
        }
    }

    public void publishOAuthClientChange(@NotNull IdpConfiguration idpConfig) {
        Intrinsics.checkNotNullParameter((Object)idpConfig, (String)"idpConfig");
        if (idpConfig.getEnabled()) {
            this.oauthClientProducer.publish$admin_service(this.idpConfigToClientRegistration(idpConfig));
        } else {
            this.oauthClientProducer.publishDeletion$admin_service(idpConfig.getConfigId());
        }
    }

    public void publishOAuthClientDeletion(@NotNull ClientRegistrationId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.oauthClientProducer.publishDeletion$admin_service(id);
    }

    public void republishOAuthClients(@NotNull Runnable doRepublish) {
        Intrinsics.checkNotNullParameter((Object)doRepublish, (String)"doRepublish");
        this.oauthClientProducer.republish$admin_service(doRepublish);
    }

    /*
     * WARNING - void declaration
     */
    private ClientRegistration idpConfigToClientRegistration(IdpConfiguration conf) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        CharSequence charSequence;
        Regex regex;
        Object object2;
        String[] $this$idpConfigToClientRegistration_u24lambda_u245 = object2 = ClientRegistration.newBuilder();
        boolean $i$a$-apply-Publisher$idpConfigToClientRegistration$22 = false;
        $this$idpConfigToClientRegistration_u24lambda_u245.setRegistrationId(conf.getConfigId().toString());
        $this$idpConfigToClientRegistration_u24lambda_u245.setTenantId(conf.getTenantId().asItemId());
        String string = conf.getClientId();
        if (string == null) {
            string = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setClientId(string);
        String string2 = conf.getClientSecret();
        if (string2 == null) {
            string2 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setClientSecret(string2);
        String string3 = conf.getIdpName();
        if (string3 == null) {
            string3 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setClientName(string3);
        $this$idpConfigToClientRegistration_u24lambda_u245.setAuthorizationGrantType(conf.getAuthorizationGrantType().getValue());
        String string4 = conf.getScope();
        if (string4 == null || (string4 = (regex = new Regex("\\s")).replace(charSequence = (CharSequence)string4, (String)(object = ""))) == null) {
            string4 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setScope(string4);
        String string5 = conf.getAuthorizationUri();
        if (string5 == null) {
            string5 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setAuthorizationUri(string5);
        String string6 = conf.getTokenUri();
        if (string6 == null) {
            string6 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setTokenUri(string6);
        String string7 = conf.getUserInfoUri();
        if (string7 == null) {
            string7 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setUserInfoUri(string7);
        String string8 = conf.getIssuerUri();
        if (string8 == null) {
            string8 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setIssuerUri(string8);
        String string9 = conf.getJwkSetUri();
        if (string9 == null) {
            string9 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setJwkSetUri(string9);
        String string10 = conf.getUserNameAttribute();
        if (string10 == null) {
            string10 = "";
        }
        $this$idpConfigToClientRegistration_u24lambda_u245.setUserNameAttribute(string10);
        $this$idpConfigToClientRegistration_u24lambda_u245.setAutomaticMode(conf.getAutomaticMode());
        $this$idpConfigToClientRegistration_u24lambda_u245.setDefaultProvider(conf.getDefaultProvider());
        String[] stringArray = object2;
        object2 = new String[]{","};
        object2 = StringsKt.split$default((CharSequence)conf.getTargets(), (String[])object2, (boolean)false, (int)0, (int)6, null);
        String[] stringArray2 = stringArray;
        boolean $i$f$map = false;
        void $i$a$-apply-Publisher$idpConfigToClientRegistration$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string11 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ClientRegistration.Target.valueOf((String)it));
        }
        ClientRegistration clientRegistration = stringArray2.addAllTargets((Iterable)((List)destination$iv$iv)).build();
        Intrinsics.checkNotNullExpressionValue((Object)clientRegistration, (String)"newBuilder().apply {\n   \u2026et.valueOf(it) }).build()");
        return clientRegistration;
    }
}

