/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.deserializier;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.util.TenantIdDeserializer;
import de.justsoftware.admin.util.UserGroupIdDeserializer;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.support.serializer.DeserializationException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/admin/kafka/deserializier/UserGroupDeserializer;", "Lorg/apache/kafka/common/serialization/Deserializer;", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "topic", "", "data", "", "admin-service"})
public final class UserGroupDeserializer
implements Deserializer<UserGroup> {
    @NotNull
    private final ObjectMapper jsonMapper;

    public UserGroupDeserializer() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper().configure\u2026NKNOWN_PROPERTIES, false)");
        this.jsonMapper = objectMapper;
        this.jsonMapper.registerModule((Module)UserGroupIdDeserializer.INSTANCE);
        this.jsonMapper.registerModule((Module)TenantIdDeserializer.INSTANCE);
    }

    @Nullable
    public UserGroup deserialize(@Nullable String topic, @Nullable byte[] data) {
        UserGroup userGroup;
        if (data == null) {
            return null;
        }
        try {
            userGroup = (UserGroup)this.jsonMapper.readValue(data, UserGroup.class);
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to deserialize data to UserGroup", data, false, (Throwable)e);
        }
        return userGroup;
    }
}

