/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.deserializier;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.admin.kafka.model.TenantKafkaDto;
import de.justsoftware.admin.util.DocumentIdDeserializer;
import de.justsoftware.admin.util.HexColorDeserializer;
import de.justsoftware.admin.util.ProfileIdDeserializer;
import de.justsoftware.admin.util.TenantIdDeserializer;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.Deserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.support.serializer.DeserializationException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/admin/kafka/deserializier/TenantDeserializer;", "Lorg/apache/kafka/common/serialization/Deserializer;", "Lde/justsoftware/admin/kafka/model/TenantKafkaDto;", "()V", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserialize", "topic", "", "data", "", "admin-service"})
public final class TenantDeserializer
implements Deserializer<TenantKafkaDto> {
    @NotNull
    private final ObjectMapper jsonMapper;

    public TenantDeserializer() {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"ObjectMapper().configure\u2026NKNOWN_PROPERTIES, false)");
        this.jsonMapper = objectMapper;
        Module[] moduleArray = new Module[]{(Module)DocumentIdDeserializer.INSTANCE, (Module)HexColorDeserializer.INSTANCE, (Module)ProfileIdDeserializer.INSTANCE, (Module)TenantIdDeserializer.INSTANCE};
        this.jsonMapper.registerModules(moduleArray);
    }

    @NotNull
    public TenantKafkaDto deserialize(@Nullable String topic, @Nullable byte[] data) {
        TenantKafkaDto tenantKafkaDto;
        try {
            Object object = this.jsonMapper.readValue(data, TenantKafkaDto.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n        jsonMapper.rea\u2026fkaDto::class.java)\n    }");
            tenantKafkaDto = (TenantKafkaDto)object;
        }
        catch (IOException e) {
            throw new DeserializationException("Failed to deserialize data to Tenant", data, false, (Throwable)e);
        }
        return tenantKafkaDto;
    }
}

