/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.kafka.consumer;

import de.justsoftware.admin.application.kafka.KafkaConsumerApplicationService;
import de.justsoftware.admin.kafka.consumer.KafkaConsumer;
import de.justsoftware.admin.kafka.model.TenantKafkaDto;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00022\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u0003H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/admin/kafka/consumer/KafkaTenantConsumer;", "Lde/justsoftware/admin/kafka/consumer/KafkaConsumer;", "", "Lde/justsoftware/admin/kafka/model/TenantKafkaDto;", "kafkaConsumerApplicationService", "Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;", "(Lde/justsoftware/admin/application/kafka/KafkaConsumerApplicationService;)V", "listen", "", "key", "payload", "admin-service"})
public class KafkaTenantConsumer
implements KafkaConsumer<String, TenantKafkaDto> {
    @NotNull
    private final KafkaConsumerApplicationService kafkaConsumerApplicationService;

    public KafkaTenantConsumer(@NotNull KafkaConsumerApplicationService kafkaConsumerApplicationService) {
        Intrinsics.checkNotNullParameter((Object)kafkaConsumerApplicationService, (String)"kafkaConsumerApplicationService");
        this.kafkaConsumerApplicationService = kafkaConsumerApplicationService;
    }

    @KafkaListener(containerFactory="kafkaTenantListenerContainerFactory", topics={"just.toro.migration.tenants"})
    public void listen(@Header(value="kafka_receivedMessageKey") @NotNull String key, @Payload(required=false) @Nullable TenantKafkaDto payload) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (payload != null) {
            this.kafkaConsumerApplicationService.addTenantFromKafka(payload);
        }
    }
}

