/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.graphql.dataFetchers;

import com.netflix.graphql.dgs.DgsComponent;
import com.netflix.graphql.dgs.DgsData;
import com.netflix.graphql.dgs.DgsDataFetchingEnvironment;
import com.netflix.graphql.dgs.DgsMutation;
import com.netflix.graphql.dgs.DgsTypeResolver;
import com.netflix.graphql.dgs.InputArgument;
import com.netflix.graphql.dgs.context.DgsContext;
import de.justsoftware.admin.application.web.UserApplicationService;
import de.justsoftware.admin.authorization.AuthorizationContext;
import de.justsoftware.admin.graphql.dataFetchers.util.FetcherUtilsKt;
import de.justsoftware.admin.graphql.dataFetchers.util.ModelConverterKt;
import de.justsoftware.admin.graphql.generated.types.AppPermission;
import de.justsoftware.admin.graphql.generated.types.Grantee;
import de.justsoftware.admin.graphql.generated.types.Profile;
import de.justsoftware.admin.graphql.generated.types.ProfileInput;
import de.justsoftware.admin.graphql.generated.types.Tenant;
import de.justsoftware.admin.graphql.generated.types.TenantPermission;
import de.justsoftware.admin.graphql.generated.types.UserGroup;
import de.justsoftware.admin.model.itemid.impl.GranteeId;
import de.justsoftware.admin.model.itemid.impl.ProfileId;
import de.justsoftware.admin.model.itemid.impl.TenantId;
import de.justsoftware.admin.model.itemid.impl.UserGroupId;
import graphql.schema.DataFetchingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DgsComponent
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0017J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0010\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/justsoftware/admin/graphql/dataFetchers/UserFetcher;", "", "applicationService", "Lde/justsoftware/admin/application/web/UserApplicationService;", "(Lde/justsoftware/admin/application/web/UserApplicationService;)V", "allTenantUsersGroup", "Lde/justsoftware/admin/graphql/generated/types/UserGroup;", "dfe", "Lcom/netflix/graphql/dgs/DgsDataFetchingEnvironment;", "createProfile", "Lde/justsoftware/admin/model/itemid/impl/ProfileId;", "input", "Lde/justsoftware/admin/graphql/generated/types/ProfileInput;", "grantee", "Lde/justsoftware/admin/graphql/generated/types/Grantee;", "granteeByTenantPermission", "resolveGrantee", "granteeId", "Lde/justsoftware/admin/model/itemid/impl/GranteeId;", "", "admin-service"})
public class UserFetcher {
    @NotNull
    private final UserApplicationService applicationService;

    public UserFetcher(@NotNull UserApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        this.applicationService = applicationService;
    }

    @DgsMutation(field="createProfile")
    @NotNull
    public ProfileId createProfile(@NotNull DgsDataFetchingEnvironment dfe, @InputArgument @NotNull ProfileInput input) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.applicationService.createProfile(ModelConverterKt.toDomain$default((ProfileInput)input, (boolean)false, (int)1, null), (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe));
    }

    @DgsData(parentType="AppPermission", field="grantee")
    @NotNull
    public Grantee grantee(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        GranteeId granteeId = GranteeId.Companion.from(((AppPermission)dfe.getSource()).getGranteeId());
        return this.resolveGrantee(dfe, granteeId);
    }

    @DgsData(parentType="Tenant", field="allTenantUsersGroup")
    @NotNull
    public UserGroup allTenantUsersGroup(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        TenantId tenantId = ((Tenant)dfe.getSource()).getId();
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.user.model.UserGroup)this.applicationService.getAllTenantUsersGroup(tenantId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsData(parentType="TenantPermission", field="grantee")
    @NotNull
    public Grantee granteeByTenantPermission(@NotNull DgsDataFetchingEnvironment dfe) {
        Intrinsics.checkNotNullParameter((Object)dfe, (String)"dfe");
        GranteeId granteeId = GranteeId.Companion.from(((TenantPermission)dfe.getSource()).getGranteeId());
        return this.resolveGrantee(dfe, granteeId);
    }

    private Grantee resolveGrantee(DgsDataFetchingEnvironment dfe, GranteeId granteeId) {
        if (FetcherUtilsKt.isIdOnlyQuery((DataFetchingEnvironment)((DataFetchingEnvironment)dfe))) {
            Grantee grantee;
            GranteeId granteeId2 = granteeId;
            if (granteeId2 instanceof ProfileId) {
                grantee = (Grantee)new Profile.Builder().withId((ProfileId)granteeId).build();
            } else if (granteeId2 instanceof UserGroupId) {
                grantee = (Grantee)new UserGroup.Builder().withId((UserGroupId)granteeId).build();
            } else {
                throw new InternalError("unknown granteeId");
            }
            return grantee;
        }
        return ModelConverterKt.toGql((de.justsoftware.admin.domain.user.model.Grantee)this.applicationService.getOne(granteeId, (AuthorizationContext)DgsContext.Companion.getCustomContext((DataFetchingEnvironment)dfe)));
    }

    @DgsTypeResolver(name="Grantee")
    @NotNull
    public String resolveGrantee(@NotNull Grantee grantee) {
        String string;
        Intrinsics.checkNotNullParameter((Object)grantee, (String)"grantee");
        Grantee grantee2 = grantee;
        if (grantee2 instanceof Profile) {
            string = "Profile";
        } else if (grantee2 instanceof UserGroup) {
            string = "UserGroup";
        } else {
            throw new IllegalArgumentException("cant resolve grantee");
        }
        return string;
    }
}

